/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.changefeed.common;

import com.azure.cosmos.implementation.Strings;
import com.azure.cosmos.implementation.changefeed.common.ChangeFeedMode;
import com.azure.cosmos.implementation.changefeed.common.ChangeFeedStartFromInternal;
import com.azure.cosmos.implementation.changefeed.common.ChangeFeedStartFromInternalDeserializer;
import com.azure.cosmos.implementation.changefeed.common.ChangeFeedState;
import com.azure.cosmos.implementation.changefeed.common.ChangeFeedStateV1;
import com.azure.cosmos.implementation.feedranges.FeedRangeContinuation;
import com.azure.cosmos.implementation.feedranges.FeedRangeContinuationDeserializer;
import com.azure.cosmos.implementation.feedranges.FeedRangeInternal;
import com.azure.cosmos.implementation.feedranges.FeedRangeInternalDeserializer;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import java.util.Locale;

public class ChangeFeedStateDeserializer
extends StdDeserializer<ChangeFeedState> {
    private static final long serialVersionUID = 1L;

    public ChangeFeedStateDeserializer() {
        this(null);
    }

    public ChangeFeedStateDeserializer(Class<?> vc) {
        super(vc);
    }

    public ChangeFeedState deserialize(JsonParser parser, DeserializationContext context) throws IOException {
        FeedRangeInternal feedRange;
        ChangeFeedMode mode;
        JsonNode rootNode = (JsonNode)parser.getCodec().readTree(parser);
        ObjectMapper mapper = (ObjectMapper)parser.getCodec();
        JsonNode versionNode = rootNode.get("V");
        if (versionNode == null || !versionNode.isInt()) {
            throw JsonMappingException.from((JsonParser)parser, (String)String.format("Required property '%s' missing or does not have a valid value.", "V"));
        }
        int version = versionNode.intValue();
        if (version != 1) {
            throw JsonMappingException.from((JsonParser)parser, (String)String.format("Version '%d' not supported.", version));
        }
        JsonNode ridNode = rootNode.get("Rid");
        if (ridNode == null || !ridNode.isTextual() || Strings.isNullOrWhiteSpace(ridNode.textValue())) {
            throw JsonMappingException.from((JsonParser)parser, (String)String.format("Required property '%s' missing or does not have a valid value.", "Rid"));
        }
        JsonNode modeNode = rootNode.get("Mode");
        if (modeNode == null || !modeNode.isTextual() || Strings.isNullOrWhiteSpace(modeNode.textValue())) {
            throw JsonMappingException.from((JsonParser)parser, (String)String.format("Required property '%s' missing or does not have a valid value.", "Mode"));
        }
        try {
            mode = ChangeFeedMode.valueOf(modeNode.textValue().toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException argException) {
            throw JsonMappingException.from((JsonParser)parser, (String)String.format("Value '%s' for required property '%s' does not have a valid value.", modeNode.textValue(), "Mode"), (Throwable)argException);
        }
        JsonNode startFromNode = rootNode.get("StartFrom");
        if (startFromNode == null || !startFromNode.isObject()) {
            throw JsonMappingException.from((JsonParser)parser, (String)String.format("Required property '%s' missing or does not have a valid value.", "StartFrom"));
        }
        ChangeFeedStartFromInternal startFromSettings = ChangeFeedStartFromInternalDeserializer.deserializeStartFromInternal(startFromNode, mapper, parser);
        FeedRangeContinuation continuation = null;
        JsonNode continuationNode = rootNode.get("Continuation");
        if (continuationNode != null) {
            continuation = FeedRangeContinuationDeserializer.deserializeFeedRangeContinuation(continuationNode, mapper, parser);
            feedRange = continuation.getFeedRange();
        } else {
            feedRange = FeedRangeInternalDeserializer.deserializeFeedRange(rootNode, mapper, parser);
        }
        return new ChangeFeedStateV1(ridNode.textValue(), feedRange, mode, startFromSettings, continuation);
    }
}

