/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.caches;

import com.azure.cosmos.CosmosException;
import com.azure.cosmos.implementation.DiagnosticsClientContext;
import com.azure.cosmos.implementation.DocumentCollection;
import com.azure.cosmos.implementation.Exceptions;
import com.azure.cosmos.implementation.MetadataDiagnosticsContext;
import com.azure.cosmos.implementation.NotFoundException;
import com.azure.cosmos.implementation.OperationType;
import com.azure.cosmos.implementation.PartitionKeyRange;
import com.azure.cosmos.implementation.ResourceType;
import com.azure.cosmos.implementation.RxDocumentClientImpl;
import com.azure.cosmos.implementation.RxDocumentServiceRequest;
import com.azure.cosmos.implementation.Utils;
import com.azure.cosmos.implementation.apachecommons.collections.CollectionUtils;
import com.azure.cosmos.implementation.apachecommons.lang.tuple.ImmutablePair;
import com.azure.cosmos.implementation.caches.AsyncCache;
import com.azure.cosmos.implementation.caches.IPartitionKeyRangeCache;
import com.azure.cosmos.implementation.caches.RxCollectionCache;
import com.azure.cosmos.implementation.routing.CollectionRoutingMap;
import com.azure.cosmos.implementation.routing.IServerIdentity;
import com.azure.cosmos.implementation.routing.InMemoryCollectionRoutingMap;
import com.azure.cosmos.implementation.routing.Range;
import com.azure.cosmos.models.CosmosQueryRequestOptions;
import com.azure.cosmos.models.ModelBridgeInternal;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class RxPartitionKeyRangeCache
implements IPartitionKeyRangeCache {
    private final Logger logger = LoggerFactory.getLogger(RxPartitionKeyRangeCache.class);
    private final AsyncCache<String, CollectionRoutingMap> routingMapCache = new AsyncCache();
    private final RxDocumentClientImpl client;
    private final RxCollectionCache collectionCache;
    private final DiagnosticsClientContext clientContext;

    public RxPartitionKeyRangeCache(RxDocumentClientImpl client, RxCollectionCache collectionCache) {
        this.client = client;
        this.collectionCache = collectionCache;
        this.clientContext = client;
    }

    @Override
    public Mono<Utils.ValueHolder<CollectionRoutingMap>> tryLookupAsync(MetadataDiagnosticsContext metaDataDiagnosticsContext, String collectionRid, CollectionRoutingMap previousValue, Map<String, Object> properties) {
        return this.routingMapCache.getAsync(collectionRid, previousValue, () -> this.getRoutingMapForCollectionAsync(metaDataDiagnosticsContext, collectionRid, previousValue, properties)).map(Utils.ValueHolder::new).onErrorResume(err -> {
            this.logger.debug("tryLookupAsync on collectionRid {} encountered failure", (Object)collectionRid, err);
            CosmosException dce = Utils.as(err, CosmosException.class);
            if (dce != null && Exceptions.isStatusCode(dce, 404)) {
                return Mono.just(new Utils.ValueHolder<Object>(null));
            }
            return Mono.error((Throwable)err);
        });
    }

    @Override
    public Mono<Utils.ValueHolder<CollectionRoutingMap>> tryLookupAsync(MetadataDiagnosticsContext metaDataDiagnosticsContext, String collectionRid, CollectionRoutingMap previousValue, boolean forceRefreshCollectionRoutingMap, Map<String, Object> properties) {
        return this.tryLookupAsync(metaDataDiagnosticsContext, collectionRid, previousValue, properties);
    }

    @Override
    public Mono<Utils.ValueHolder<List<PartitionKeyRange>>> tryGetOverlappingRangesAsync(MetadataDiagnosticsContext metaDataDiagnosticsContext, String collectionRid, Range<String> range, boolean forceRefresh, Map<String, Object> properties) {
        Mono<Utils.ValueHolder<CollectionRoutingMap>> routingMapObs = this.tryLookupAsync(metaDataDiagnosticsContext, collectionRid, null, properties);
        return routingMapObs.flatMap(routingMapValueHolder -> {
            if (forceRefresh && routingMapValueHolder.v != null) {
                this.logger.debug("tryGetOverlappingRangesAsync with forceRefresh on collectionRid {}", (Object)collectionRid);
                return this.tryLookupAsync(metaDataDiagnosticsContext, collectionRid, (CollectionRoutingMap)routingMapValueHolder.v, properties);
            }
            return Mono.just((Object)routingMapValueHolder);
        }).map(routingMapValueHolder -> {
            if (routingMapValueHolder.v != null) {
                return new Utils.ValueHolder<ArrayList<PartitionKeyRange>>(new ArrayList<PartitionKeyRange>(((CollectionRoutingMap)routingMapValueHolder.v).getOverlappingRanges(range)));
            }
            this.logger.debug("Routing Map Null for collection: {} for range: {}, forceRefresh:{}", new Object[]{collectionRid, range, forceRefresh});
            return new Utils.ValueHolder<Object>(null);
        });
    }

    @Override
    public Mono<Utils.ValueHolder<PartitionKeyRange>> tryGetPartitionKeyRangeByIdAsync(MetadataDiagnosticsContext metaDataDiagnosticsContext, String collectionResourceId, String partitionKeyRangeId, boolean forceRefresh, Map<String, Object> properties) {
        Mono<Utils.ValueHolder<CollectionRoutingMap>> routingMapObs = this.tryLookupAsync(metaDataDiagnosticsContext, collectionResourceId, null, properties);
        return routingMapObs.flatMap(routingMapValueHolder -> {
            if (forceRefresh && routingMapValueHolder.v != null) {
                return this.tryLookupAsync(metaDataDiagnosticsContext, collectionResourceId, (CollectionRoutingMap)routingMapValueHolder.v, properties);
            }
            return Mono.just((Object)routingMapValueHolder);
        }).map(routingMapValueHolder -> {
            if (routingMapValueHolder.v != null) {
                return new Utils.ValueHolder<PartitionKeyRange>(((CollectionRoutingMap)routingMapValueHolder.v).getRangeByPartitionKeyRangeId(partitionKeyRangeId));
            }
            this.logger.debug("Routing Map Null for collection: {}, PartitionKeyRangeId: {}, forceRefresh:{}", new Object[]{collectionResourceId, partitionKeyRangeId, forceRefresh});
            return new Utils.ValueHolder<Object>(null);
        });
    }

    @Override
    public Mono<Utils.ValueHolder<PartitionKeyRange>> tryGetRangeByPartitionKeyRangeId(MetadataDiagnosticsContext metaDataDiagnosticsContext, String collectionRid, String partitionKeyRangeId, Map<String, Object> properties) {
        Mono routingMapObs = this.routingMapCache.getAsync(collectionRid, null, () -> this.getRoutingMapForCollectionAsync(metaDataDiagnosticsContext, collectionRid, null, properties)).map(Utils.ValueHolder::new);
        return routingMapObs.map(routingMapValueHolder -> new Utils.ValueHolder<PartitionKeyRange>(((CollectionRoutingMap)routingMapValueHolder.v).getRangeByPartitionKeyRangeId(partitionKeyRangeId))).onErrorResume(err -> {
            CosmosException dce = Utils.as(err, CosmosException.class);
            this.logger.debug("tryGetRangeByPartitionKeyRangeId on collectionRid {} and partitionKeyRangeId {} encountered failure", new Object[]{collectionRid, partitionKeyRangeId, err});
            if (dce != null && Exceptions.isNotFound(dce)) {
                return Mono.just(new Utils.ValueHolder<Object>(null));
            }
            return dce != null ? Mono.error((Throwable)((Object)dce)) : Mono.error((Throwable)err);
        });
    }

    public Mono<Utils.ValueHolder<CollectionRoutingMap>> refreshAsync(MetadataDiagnosticsContext metaDataDiagnosticsContext, String collectionRid) {
        return this.tryLookupAsync(metaDataDiagnosticsContext, collectionRid, null, null).flatMap(collectionRoutingMapValueHolder -> this.tryLookupAsync(metaDataDiagnosticsContext, collectionRid, (CollectionRoutingMap)collectionRoutingMapValueHolder.v, null));
    }

    private Mono<CollectionRoutingMap> getRoutingMapForCollectionAsync(MetadataDiagnosticsContext metaDataDiagnosticsContext, String collectionRid, CollectionRoutingMap previousRoutingMap, Map<String, Object> properties) {
        Mono<List<PartitionKeyRange>> rangesObs = this.getPartitionKeyRange(metaDataDiagnosticsContext, collectionRid, false, properties);
        return rangesObs.flatMap(ranges -> {
            CollectionRoutingMap routingMap;
            List<ImmutablePair<PartitionKeyRange, IServerIdentity>> rangesTuples = ranges.stream().map(range -> new ImmutablePair<PartitionKeyRange, IServerIdentity>((PartitionKeyRange)range, null)).collect(Collectors.toList());
            if (previousRoutingMap == null) {
                HashSet goneRanges = new HashSet(ranges.stream().flatMap(range -> CollectionUtils.emptyIfNull(range.getParents()).stream()).collect(Collectors.toSet()));
                routingMap = InMemoryCollectionRoutingMap.tryCreateCompleteRoutingMap(rangesTuples.stream().filter(tuple -> !goneRanges.contains(((PartitionKeyRange)tuple.left).getId())).collect(Collectors.toList()), collectionRid);
            } else {
                routingMap = previousRoutingMap.tryCombine(rangesTuples);
            }
            if (routingMap == null) {
                return Mono.error((Throwable)((Object)new NotFoundException(String.format("GetRoutingMapForCollectionAsync(collectionRid: {%s}), RANGE information either doesn't exist or is not complete.", collectionRid))));
            }
            return Mono.just((Object)routingMap);
        });
    }

    private Mono<List<PartitionKeyRange>> getPartitionKeyRange(MetadataDiagnosticsContext metaDataDiagnosticsContext, String collectionRid, boolean forceRefresh, Map<String, Object> properties) {
        RxDocumentServiceRequest request = RxDocumentServiceRequest.create(this.clientContext, OperationType.ReadFeed, collectionRid, ResourceType.PartitionKeyRange, null);
        request.requestContext.resolvedCollectionRid = collectionRid;
        Mono collectionObs = this.collectionCache.resolveCollectionAsync(metaDataDiagnosticsContext, request).map(collectionValueHolder -> (DocumentCollection)collectionValueHolder.v);
        return collectionObs.flatMap(coll -> {
            CosmosQueryRequestOptions cosmosQueryRequestOptions = new CosmosQueryRequestOptions();
            if (properties != null) {
                ModelBridgeInternal.setQueryRequestOptionsProperties(cosmosQueryRequestOptions, properties);
            }
            Instant addressCallStartTime = Instant.now();
            return this.client.readPartitionKeyRanges(coll.getSelfLink(), cosmosQueryRequestOptions).flatMap(p -> {
                if (metaDataDiagnosticsContext != null) {
                    Instant addressCallEndTime = Instant.now();
                    MetadataDiagnosticsContext.MetadataDiagnostics metaDataDiagnostic = new MetadataDiagnosticsContext.MetadataDiagnostics(addressCallStartTime, addressCallEndTime, MetadataDiagnosticsContext.MetadataType.PARTITION_KEY_RANGE_LOOK_UP);
                    metaDataDiagnosticsContext.addMetaDataDiagnostic(metaDataDiagnostic);
                }
                return Flux.fromIterable(p.getResults());
            }, 1).collectList();
        });
    }
}

