/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.caches;

import java.util.Optional;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

class AsyncLazy<TValue> {
    private static final Logger logger = LoggerFactory.getLogger(AsyncLazy.class);
    private final Mono<TValue> single;
    private volatile TValue value;
    private volatile boolean failed;

    public AsyncLazy(Callable<Mono<TValue>> func) {
        this(Mono.defer(() -> {
            logger.debug("using Function<Mono<TValue>> {}", (Object)func);
            try {
                return (Mono)func.call();
            }
            catch (Exception e) {
                return Mono.error((Throwable)e);
            }
        }));
    }

    public AsyncLazy(TValue value) {
        this.single = Mono.just(value);
        this.value = value;
        this.failed = false;
    }

    private AsyncLazy(Mono<TValue> single) {
        logger.debug("constructor");
        this.single = single.doOnSuccess(v -> {
            this.value = v;
        }).doOnError(e -> {
            this.failed = true;
        }).cache();
    }

    public Mono<TValue> single() {
        return this.single;
    }

    public boolean isSucceeded() {
        return this.value != null;
    }

    public Optional<TValue> tryGet() {
        TValue result = this.value;
        if (result == null) {
            return Optional.empty();
        }
        return Optional.of(result);
    }

    public boolean isFaulted() {
        return this.failed;
    }
}

