/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.batch;

import com.azure.cosmos.implementation.JsonSerializable;
import com.azure.cosmos.implementation.RequestOptions;
import com.azure.cosmos.implementation.apachecommons.lang.StringUtils;
import com.azure.cosmos.implementation.batch.BulkExecutorUtil;
import com.azure.cosmos.implementation.batch.BulkOperationRetryPolicy;
import com.azure.cosmos.implementation.batch.CosmosItemOperationBase;
import com.azure.cosmos.implementation.guava25.base.Preconditions;
import com.azure.cosmos.implementation.patch.PatchUtil;
import com.azure.cosmos.models.CosmosItemOperationType;
import com.azure.cosmos.models.CosmosPatchOperations;
import com.azure.cosmos.models.ModelBridgeInternal;
import com.azure.cosmos.models.PartitionKey;

public final class ItemBulkOperation<TInternal, TContext>
extends CosmosItemOperationBase {
    private final TInternal item;
    private final TContext context;
    private final String id;
    private final PartitionKey partitionKey;
    private final CosmosItemOperationType operationType;
    private final RequestOptions requestOptions;
    private String partitionKeyJson;
    private BulkOperationRetryPolicy bulkOperationRetryPolicy;

    public ItemBulkOperation(CosmosItemOperationType operationType, String id, PartitionKey partitionKey, RequestOptions requestOptions, TInternal item, TContext context) {
        Preconditions.checkNotNull(operationType, "expected non-null operationType");
        this.operationType = operationType;
        this.partitionKey = partitionKey;
        this.id = id;
        this.item = item;
        this.context = context;
        this.requestOptions = requestOptions;
    }

    @Override
    JsonSerializable getSerializedOperationInternal() {
        JsonSerializable jsonSerializable = new JsonSerializable();
        jsonSerializable.set("operationType", ModelBridgeInternal.getOperationValueForCosmosItemOperationType(this.getOperationType()));
        if (StringUtils.isNotEmpty(this.getPartitionKeyJson())) {
            jsonSerializable.set("partitionKey", this.getPartitionKeyJson());
        }
        if (StringUtils.isNotEmpty(this.getId())) {
            jsonSerializable.set("id", this.getId());
        }
        if (this.getItemInternal() != null) {
            if (this.getOperationType() == CosmosItemOperationType.PATCH) {
                jsonSerializable.set("resourceBody", PatchUtil.serializableBatchPatchOperation((CosmosPatchOperations)this.getItemInternal(), this.getRequestOptions()));
            } else {
                jsonSerializable.set("resourceBody", this.getItemInternal());
            }
        }
        if (this.getRequestOptions() != null) {
            RequestOptions requestOptions = this.getRequestOptions();
            if (StringUtils.isNotEmpty(requestOptions.getIfMatchETag())) {
                jsonSerializable.set("ifMatch", requestOptions.getIfMatchETag());
            }
            if (StringUtils.isNotEmpty(requestOptions.getIfNoneMatchETag())) {
                jsonSerializable.set("ifNoneMatch", requestOptions.getIfNoneMatchETag());
            }
            if (requestOptions.isContentResponseOnWriteEnabled() != null && !requestOptions.isContentResponseOnWriteEnabled().booleanValue() && BulkExecutorUtil.isWriteOperation(this.operationType)) {
                jsonSerializable.set("minimalReturnPreference", true);
            }
        }
        return jsonSerializable;
    }

    TInternal getItemInternal() {
        return this.item;
    }

    @Override
    public <T> T getItem() {
        return (T)this.item;
    }

    @Override
    public <T> T getContext() {
        return (T)this.context;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public PartitionKey getPartitionKeyValue() {
        return this.partitionKey;
    }

    @Override
    public CosmosItemOperationType getOperationType() {
        return this.operationType;
    }

    public RequestOptions getRequestOptions() {
        return this.requestOptions;
    }

    private String getPartitionKeyJson() {
        return this.partitionKeyJson;
    }

    void setPartitionKeyJson(String value) {
        this.partitionKeyJson = value;
    }

    BulkOperationRetryPolicy getRetryPolicy() {
        return this.bulkOperationRetryPolicy;
    }

    void setRetryPolicy(BulkOperationRetryPolicy bulkOperationRetryPolicy) {
        this.bulkOperationRetryPolicy = bulkOperationRetryPolicy;
    }
}

