/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation;

import com.azure.cosmos.implementation.IRetryPolicy;
import com.azure.cosmos.implementation.RetryContext;
import com.azure.cosmos.implementation.ShouldRetryResult;
import com.azure.cosmos.implementation.apachecommons.lang.time.StopWatch;
import com.azure.cosmos.implementation.directconnectivity.WebExceptionUtility;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class WebExceptionRetryPolicy
implements IRetryPolicy {
    private static final Logger logger = LoggerFactory.getLogger(WebExceptionRetryPolicy.class);
    private static final int waitTimeInSeconds = 30;
    private static final int initialBackoffSeconds = 1;
    private static final int backoffMultiplier = 2;
    private StopWatch durationTimer = new StopWatch();
    private int attemptCount = 1;
    private int currentBackoffSeconds = 1;
    private RetryContext retryContext;

    public WebExceptionRetryPolicy() {
        this.durationTimer.start();
    }

    public WebExceptionRetryPolicy(RetryContext retryContext) {
        this.durationTimer.start();
        this.retryContext = retryContext;
    }

    @Override
    public Mono<ShouldRetryResult> shouldRetry(Exception exception) {
        Duration backoffTime = Duration.ofSeconds(0L);
        if (!WebExceptionUtility.isWebExceptionRetriable(exception)) {
            this.durationTimer.stop();
            return Mono.just((Object)ShouldRetryResult.noRetryOnNonRelatedException());
        }
        if (this.attemptCount++ > 1) {
            int remainingSeconds = 30 - Math.toIntExact(this.durationTimer.getTime(TimeUnit.SECONDS));
            if (remainingSeconds <= 0) {
                this.durationTimer.stop();
                return Mono.just((Object)ShouldRetryResult.noRetry());
            }
            backoffTime = Duration.ofSeconds(Math.min(this.currentBackoffSeconds, remainingSeconds));
            this.currentBackoffSeconds *= 2;
        }
        logger.warn("Received retriable web exception, will retry", (Throwable)exception);
        return Mono.just((Object)ShouldRetryResult.retryAfter(backoffTime));
    }

    @Override
    public RetryContext getRetryContext() {
        return this.retryContext;
    }
}

