/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation;

import com.azure.cosmos.CosmosException;
import com.azure.cosmos.implementation.Configs;
import com.azure.cosmos.implementation.IRetryPolicy;
import com.azure.cosmos.implementation.RetryContext;
import com.azure.cosmos.implementation.ShouldRetryResult;
import com.azure.cosmos.implementation.directconnectivity.TimeoutHelper;
import java.time.Duration;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class SessionTokenMismatchRetryPolicy
implements IRetryPolicy {
    private static final Logger LOGGER = LoggerFactory.getLogger(SessionTokenMismatchRetryPolicy.class);
    private static final int BACKOFF_MULTIPLIER = 2;
    private final Duration maximumBackoff;
    private final TimeoutHelper waitTimeTimeoutHelper;
    private final AtomicInteger retryCount;
    private Duration currentBackoff;
    private RetryContext retryContext;

    public SessionTokenMismatchRetryPolicy(RetryContext retryContext, int waitTimeInMilliSeconds) {
        this.waitTimeTimeoutHelper = new TimeoutHelper(Duration.ofMillis(waitTimeInMilliSeconds));
        this.maximumBackoff = Duration.ofMillis(Configs.getSessionTokenMismatchMaximumBackoffTimeInMs());
        this.retryCount = new AtomicInteger();
        this.retryCount.set(0);
        this.currentBackoff = Duration.ofMillis(Configs.getSessionTokenMismatchInitialBackoffTimeInMs());
        this.retryContext = retryContext;
    }

    public SessionTokenMismatchRetryPolicy(RetryContext retryContext) {
        this(retryContext, Configs.getSessionTokenMismatchDefaultWaitTimeInMs());
    }

    @Override
    public Mono<ShouldRetryResult> shouldRetry(Exception e) {
        if (!(e instanceof CosmosException)) {
            return Mono.just((Object)ShouldRetryResult.noRetryOnNonRelatedException());
        }
        CosmosException cosmosException = (CosmosException)((Object)e);
        if (cosmosException.getStatusCode() != 404 || cosmosException.getSubStatusCode() != 1002) {
            LOGGER.debug("SessionTokenMismatchRetryPolicy not retrying because StatusCode or SubStatusCode not found.");
            return Mono.just((Object)ShouldRetryResult.noRetryOnNonRelatedException());
        }
        if (this.waitTimeTimeoutHelper.isElapsed()) {
            LOGGER.warn("SessionTokenMismatchRetryPolicy not retrying because it has exceeded the time limit. Retry count = {}", (Object)this.retryCount);
            return Mono.just((Object)ShouldRetryResult.noRetry());
        }
        Duration effectiveBackoff = Duration.ZERO;
        if (this.retryCount.getAndIncrement() > 0) {
            effectiveBackoff = SessionTokenMismatchRetryPolicy.getEffectiveBackoff(this.currentBackoff, this.waitTimeTimeoutHelper.getRemainingTime());
            this.currentBackoff = SessionTokenMismatchRetryPolicy.getEffectiveBackoff(Duration.ofMillis(this.currentBackoff.toMillis() * 2L), this.maximumBackoff);
        }
        LOGGER.debug("SessionTokenMismatchRetryPolicy will retry. Retry count = {}.  Backoff time = {} ms", (Object)this.retryCount, (Object)effectiveBackoff.toMillis());
        return Mono.just((Object)ShouldRetryResult.retryAfter(effectiveBackoff));
    }

    @Override
    public RetryContext getRetryContext() {
        return this.retryContext;
    }

    private static Duration getEffectiveBackoff(Duration backoff, Duration remainingTime) {
        if (backoff.compareTo(remainingTime) > 0) {
            return remainingTime;
        }
        return backoff;
    }
}

