/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation;

import com.azure.cosmos.implementation.http.HttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LifeCycleUtils {
    private static final Logger logger = LoggerFactory.getLogger(LifeCycleUtils.class);

    public static void closeQuietly(AutoCloseable closeable) {
        try {
            if (closeable != null) {
                logger.debug("closing an instance of {}", (Object)closeable.getClass().getCanonicalName());
                closeable.close();
            }
        }
        catch (Exception e) {
            logger.warn("attempting to close an instance of {} failed", (Object)closeable.getClass().getCanonicalName(), (Object)e);
        }
    }

    public static void closeQuietly(HttpClient closeable) {
        try {
            if (closeable != null) {
                logger.debug("shutting down an instance of {}", (Object)closeable.getClass().getCanonicalName());
                closeable.shutdown();
            }
        }
        catch (Exception e) {
            logger.warn("attempting to shutdown an instance of {} failed", (Object)closeable.getClass().getCanonicalName(), (Object)e);
        }
    }
}

