/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos;

import com.azure.cosmos.CosmosAsyncClient;
import com.azure.cosmos.CosmosAsyncContainer;
import com.azure.cosmos.GlobalThroughputControlConfig;
import com.azure.cosmos.implementation.apachecommons.lang.StringUtils;
import com.azure.cosmos.implementation.guava25.base.Preconditions;
import com.azure.cosmos.util.Beta;
import java.time.Duration;

@Beta(value=Beta.SinceVersion.V4_13_0, warningText="Preview API - subject to change in non-backwards compatible way")
public class GlobalThroughputControlConfigBuilder {
    private final CosmosAsyncContainer controlContainer;
    private Duration controlItemRenewInterval;
    private Duration controlItemExpireInterval;

    GlobalThroughputControlConfigBuilder(CosmosAsyncClient client, String databaseId, String containerId) {
        Preconditions.checkNotNull(client, "Client can not be null");
        Preconditions.checkArgument(StringUtils.isNotEmpty(databaseId), "DatabaseId cannot be null nor empty");
        Preconditions.checkArgument(StringUtils.isNotEmpty(containerId), "ContainerId cannot be null nor empty");
        this.controlContainer = client.getDatabase(databaseId).getContainer(containerId);
    }

    @Beta(value=Beta.SinceVersion.V4_13_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public GlobalThroughputControlConfigBuilder setControlItemRenewInterval(Duration controlItemRenewInterval) {
        Preconditions.checkArgument(controlItemRenewInterval.getSeconds() >= 5L, "Renew interval should be no less than 5s");
        this.controlItemRenewInterval = controlItemRenewInterval;
        return this;
    }

    @Beta(value=Beta.SinceVersion.V4_13_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public GlobalThroughputControlConfigBuilder setControlItemExpireInterval(Duration controlItemExpireInterval) {
        this.controlItemExpireInterval = controlItemExpireInterval;
        return this;
    }

    @Beta(value=Beta.SinceVersion.V4_13_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public GlobalThroughputControlConfig build() {
        if (this.controlItemExpireInterval != null && this.controlItemRenewInterval != null && this.controlItemExpireInterval.getSeconds() < 2L * this.controlItemRenewInterval.getSeconds() + 1L) {
            throw new IllegalArgumentException("ControlItemExpireInterval is too small compared to ControlItemExpireInterval");
        }
        return new GlobalThroughputControlConfig(this.controlContainer, this.controlItemRenewInterval, this.controlItemExpireInterval);
    }
}

