/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos;

import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.cosmos.CosmosAsyncContainer;
import com.azure.cosmos.implementation.StoredProcedure;
import com.azure.cosmos.models.CosmosStoredProcedureProperties;
import com.azure.cosmos.models.CosmosStoredProcedureRequestOptions;
import com.azure.cosmos.models.CosmosStoredProcedureResponse;
import com.azure.cosmos.models.ModelBridgeInternal;
import java.util.List;
import reactor.core.publisher.Mono;

public class CosmosAsyncStoredProcedure {
    private final CosmosAsyncContainer cosmosContainer;
    private String id;

    CosmosAsyncStoredProcedure(String id, CosmosAsyncContainer cosmosContainer) {
        this.id = id;
        this.cosmosContainer = cosmosContainer;
    }

    public String getId() {
        return this.id;
    }

    CosmosAsyncStoredProcedure setId(String id) {
        this.id = id;
        return this;
    }

    public Mono<CosmosStoredProcedureResponse> read() {
        return this.read(null);
    }

    public Mono<CosmosStoredProcedureResponse> read(CosmosStoredProcedureRequestOptions options) {
        return FluxUtil.withContext(context -> this.readInternal(options, (Context)context));
    }

    public Mono<CosmosStoredProcedureResponse> delete() {
        return this.delete(null);
    }

    public Mono<CosmosStoredProcedureResponse> delete(CosmosStoredProcedureRequestOptions options) {
        return FluxUtil.withContext(context -> this.deleteInternal(options, (Context)context));
    }

    public Mono<CosmosStoredProcedureResponse> execute(List<Object> procedureParams, CosmosStoredProcedureRequestOptions options) {
        return FluxUtil.withContext(context -> this.executeInternal(procedureParams, options, (Context)context));
    }

    public Mono<CosmosStoredProcedureResponse> replace(CosmosStoredProcedureProperties storedProcedureProperties) {
        return this.replace(storedProcedureProperties, null);
    }

    public Mono<CosmosStoredProcedureResponse> replace(CosmosStoredProcedureProperties storedProcedureProperties, CosmosStoredProcedureRequestOptions options) {
        return FluxUtil.withContext(context -> this.replaceInternal(storedProcedureProperties, options, (Context)context));
    }

    String getURIPathSegment() {
        return "sprocs";
    }

    String getParentLink() {
        return this.cosmosContainer.getLink();
    }

    String getLink() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getParentLink());
        builder.append("/");
        builder.append(this.getURIPathSegment());
        builder.append("/");
        builder.append(this.getId());
        return builder.toString();
    }

    private Mono<CosmosStoredProcedureResponse> readInternal(CosmosStoredProcedureRequestOptions options, Context context) {
        if (options == null) {
            options = new CosmosStoredProcedureRequestOptions();
        }
        String spanName = "readStoredProcedure." + this.cosmosContainer.getId();
        Mono responseMono = this.cosmosContainer.getDatabase().getDocClientWrapper().readStoredProcedure(this.getLink(), ModelBridgeInternal.toRequestOptions(options)).map(response -> ModelBridgeInternal.createCosmosStoredProcedureResponse(response)).single();
        return this.cosmosContainer.getDatabase().getClient().getTracerProvider().traceEnabledCosmosResponsePublisher(responseMono, context, spanName, this.cosmosContainer.getDatabase().getId(), this.cosmosContainer.getDatabase().getClient().getServiceEndpoint());
    }

    private Mono<CosmosStoredProcedureResponse> deleteInternal(CosmosStoredProcedureRequestOptions options, Context context) {
        if (options == null) {
            options = new CosmosStoredProcedureRequestOptions();
        }
        String spanName = "deleteStoredProcedure." + this.cosmosContainer.getId();
        Mono responseMono = this.cosmosContainer.getDatabase().getDocClientWrapper().deleteStoredProcedure(this.getLink(), ModelBridgeInternal.toRequestOptions(options)).map(response -> ModelBridgeInternal.createCosmosStoredProcedureResponse(response)).single();
        return this.cosmosContainer.getDatabase().getClient().getTracerProvider().traceEnabledCosmosResponsePublisher(responseMono, context, spanName, this.cosmosContainer.getDatabase().getId(), this.cosmosContainer.getDatabase().getClient().getServiceEndpoint());
    }

    private Mono<CosmosStoredProcedureResponse> executeInternal(List<Object> procedureParams, CosmosStoredProcedureRequestOptions options, Context context) {
        if (options == null) {
            options = new CosmosStoredProcedureRequestOptions();
        }
        String spanName = "executeStoredProcedure." + this.cosmosContainer.getId();
        Mono responseMono = this.cosmosContainer.getDatabase().getDocClientWrapper().executeStoredProcedure(this.getLink(), ModelBridgeInternal.toRequestOptions(options), procedureParams).map(response -> ModelBridgeInternal.createCosmosStoredProcedureResponse(response)).single();
        return this.cosmosContainer.getDatabase().getClient().getTracerProvider().traceEnabledCosmosResponsePublisher(responseMono, context, spanName, this.cosmosContainer.getDatabase().getId(), this.cosmosContainer.getDatabase().getClient().getServiceEndpoint());
    }

    private Mono<CosmosStoredProcedureResponse> replaceInternal(CosmosStoredProcedureProperties storedProcedureSettings, CosmosStoredProcedureRequestOptions options, Context context) {
        if (options == null) {
            options = new CosmosStoredProcedureRequestOptions();
        }
        String spanName = "replaceStoredProcedure." + this.cosmosContainer.getId();
        Mono responseMono = this.cosmosContainer.getDatabase().getDocClientWrapper().replaceStoredProcedure(new StoredProcedure(ModelBridgeInternal.toJsonFromJsonSerializable(ModelBridgeInternal.getResource(storedProcedureSettings))), ModelBridgeInternal.toRequestOptions(options)).map(response -> ModelBridgeInternal.createCosmosStoredProcedureResponse(response)).single();
        return this.cosmosContainer.getDatabase().getClient().getTracerProvider().traceEnabledCosmosResponsePublisher(responseMono, context, spanName, this.cosmosContainer.getDatabase().getId(), this.cosmosContainer.getDatabase().getClient().getServiceEndpoint());
    }
}

