/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.test.http;

import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpMethod;
import com.azure.core.http.HttpRequest;
import com.azure.core.http.HttpResponse;
import com.azure.core.test.SyncAsyncExtension;
import com.azure.core.test.annotation.SyncAsyncTest;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.Contexts;
import com.azure.core.util.ProgressReporter;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.ObjectSerializer;
import com.azure.core.util.serializer.TypeReference;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Random;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Named;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.test.StepVerifier;

public abstract class HttpClientTests {
    private static final ClientLogger LOGGER = new ClientLogger(HttpClientTests.class);
    private static final String REQUEST_HOST = "localhost";
    private static final String PLAIN_RESPONSE = "plainBytesNoHeader";
    private static final String HEADER_RESPONSE = "plainBytesWithHeader";
    private static final String INVALID_HEADER_RESPONSE = "plainBytesInvalidHeader";
    private static final String UTF_8_BOM_RESPONSE = "utf8BomBytes";
    private static final String UTF_16BE_BOM_RESPONSE = "utf16BeBomBytes";
    private static final String UTF_16LE_BOM_RESPONSE = "utf16LeBomBytes";
    private static final String UTF_32BE_BOM_RESPONSE = "utf32BeBomBytes";
    private static final String UTF_32LE_BOM_RESPONSE = "utf32LeBomBytes";
    private static final String BOM_WITH_SAME_HEADER = "bomBytesWithSameHeader";
    private static final String BOM_WITH_DIFFERENT_HEADER = "bomBytesWithDifferentHeader";
    protected static final String ECHO_RESPONSE = "echo";
    private static final Random RANDOM = new Random();
    private static final byte[] EXPECTED_RETURN_BYTES = "Hello World!".getBytes(StandardCharsets.UTF_8);

    protected abstract HttpClient createHttpClient();

    protected abstract int getWireMockPort();

    protected boolean isSecure() {
        return false;
    }

    @SyncAsyncTest
    public void plainResponse() {
        String expected = new String(EXPECTED_RETURN_BYTES, StandardCharsets.UTF_8);
        String actual = SyncAsyncExtension.execute(() -> this.sendRequestSync(PLAIN_RESPONSE), () -> this.sendRequest(PLAIN_RESPONSE));
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @SyncAsyncTest
    public void headerResponse() {
        String expected = new String(EXPECTED_RETURN_BYTES, StandardCharsets.UTF_16BE);
        String actual = SyncAsyncExtension.execute(() -> this.sendRequestSync(HEADER_RESPONSE), () -> this.sendRequest(HEADER_RESPONSE));
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @SyncAsyncTest
    public void invalidHeaderResponse() {
        String expected = new String(EXPECTED_RETURN_BYTES, StandardCharsets.UTF_8);
        String actual = SyncAsyncExtension.execute(() -> this.sendRequestSync(INVALID_HEADER_RESPONSE), () -> this.sendRequest(INVALID_HEADER_RESPONSE));
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @SyncAsyncTest
    public void utf8BomResponse() {
        String expected = new String(EXPECTED_RETURN_BYTES, StandardCharsets.UTF_8);
        String actual = SyncAsyncExtension.execute(() -> this.sendRequestSync(UTF_8_BOM_RESPONSE), () -> this.sendRequest(UTF_8_BOM_RESPONSE));
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @SyncAsyncTest
    public void utf16BeBomResponse() {
        String expected = new String(EXPECTED_RETURN_BYTES, StandardCharsets.UTF_16BE);
        String actual = SyncAsyncExtension.execute(() -> this.sendRequestSync(UTF_16BE_BOM_RESPONSE), () -> this.sendRequest(UTF_16BE_BOM_RESPONSE));
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @SyncAsyncTest
    public void utf16LeBomResponse() {
        String expected = new String(EXPECTED_RETURN_BYTES, StandardCharsets.UTF_16LE);
        String actual = SyncAsyncExtension.execute(() -> this.sendRequestSync(UTF_16LE_BOM_RESPONSE), () -> this.sendRequest(UTF_16LE_BOM_RESPONSE));
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @SyncAsyncTest
    public void utf32BeBomResponse() {
        String expected = new String(EXPECTED_RETURN_BYTES, Charset.forName("UTF-32BE"));
        String actual = SyncAsyncExtension.execute(() -> this.sendRequestSync(UTF_32BE_BOM_RESPONSE), () -> this.sendRequest(UTF_32BE_BOM_RESPONSE));
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @SyncAsyncTest
    public void utf32LeBomResponse() {
        String expected = new String(EXPECTED_RETURN_BYTES, Charset.forName("UTF-32LE"));
        String actual = SyncAsyncExtension.execute(() -> this.sendRequestSync(UTF_32LE_BOM_RESPONSE), () -> this.sendRequest(UTF_32LE_BOM_RESPONSE));
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @SyncAsyncTest
    public void bomWithSameHeader() {
        String expected = new String(EXPECTED_RETURN_BYTES, StandardCharsets.UTF_8);
        String actual = SyncAsyncExtension.execute(() -> this.sendRequestSync(BOM_WITH_SAME_HEADER), () -> this.sendRequest(BOM_WITH_SAME_HEADER));
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @SyncAsyncTest
    public void bomWithDifferentHeader() {
        String expected = new String(EXPECTED_RETURN_BYTES, StandardCharsets.UTF_8);
        String actual = SyncAsyncExtension.execute(() -> this.sendRequestSync(BOM_WITH_DIFFERENT_HEADER), () -> this.sendRequest(BOM_WITH_DIFFERENT_HEADER));
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @SyncAsyncTest
    public void shouldBufferResponse() {
        HttpRequest request = new HttpRequest(HttpMethod.PUT, this.getRequestUrl(ECHO_RESPONSE), new HttpHeaders(), BinaryData.fromString((String)"test body"));
        Context context = Context.NONE.addData((Object)"azure-eagerly-read-response", (Object)true);
        HttpResponse response = SyncAsyncExtension.execute(() -> this.createHttpClient().sendSync(request, context), () -> this.createHttpClient().send(request, context));
        HttpResponse bufferedResponse = response.buffer();
        Assertions.assertSame((Object)response, (Object)bufferedResponse);
    }

    @SyncAsyncTest
    public void bufferedResponseCanBeReadMultipleTimes() {
        BinaryData requestBody = BinaryData.fromString((String)"test body");
        HttpRequest request = new HttpRequest(HttpMethod.PUT, this.getRequestUrl(ECHO_RESPONSE), new HttpHeaders(), requestBody);
        Context context = Context.NONE.addData((Object)"azure-eagerly-read-response", (Object)true);
        HttpResponse response = SyncAsyncExtension.execute(() -> this.createHttpClient().sendSync(request, context), () -> this.createHttpClient().send(request, context));
        Assertions.assertEquals((Object)requestBody.toString(), (Object)response.getBodyAsString().block());
        Assertions.assertEquals((Object)requestBody.toString(), (Object)response.getBodyAsString().block());
        Assertions.assertArrayEquals((byte[])requestBody.toBytes(), (byte[])((byte[])response.getBodyAsByteArray().block()));
        Assertions.assertArrayEquals((byte[])requestBody.toBytes(), (byte[])((byte[])response.getBodyAsByteArray().block()));
        Assertions.assertArrayEquals((byte[])requestBody.toBytes(), (byte[])((byte[])response.getBodyAsInputStream().map(s -> BinaryData.fromStream((InputStream)s).toBytes()).block()));
        Assertions.assertArrayEquals((byte[])requestBody.toBytes(), (byte[])((byte[])response.getBodyAsInputStream().map(s -> BinaryData.fromStream((InputStream)s).toBytes()).block()));
        Assertions.assertArrayEquals((byte[])requestBody.toBytes(), (byte[])((byte[])BinaryData.fromFlux((Flux)response.getBody()).map(BinaryData::toBytes).block()));
        Assertions.assertArrayEquals((byte[])requestBody.toBytes(), (byte[])((byte[])BinaryData.fromFlux((Flux)response.getBody()).map(BinaryData::toBytes).block()));
    }

    @ParameterizedTest
    @MethodSource(value={"getBinaryDataBodyVariants"})
    public void canSendBinaryData(BinaryData requestBody, byte[] expectedResponseBody) {
        HttpRequest request = new HttpRequest(HttpMethod.PUT, this.getRequestUrl(ECHO_RESPONSE), new HttpHeaders(), requestBody);
        StepVerifier.create((Publisher)this.createHttpClient().send(request).flatMap(HttpResponse::getBodyAsByteArray)).assertNext(responseBytes -> Assertions.assertArrayEquals((byte[])expectedResponseBody, (byte[])responseBytes)).verifyComplete();
    }

    @ParameterizedTest
    @MethodSource(value={"getBinaryDataBodyVariants"})
    public void canSendBinaryDataSync(BinaryData requestBody, byte[] expectedResponseBody) {
        HttpRequest request = new HttpRequest(HttpMethod.PUT, this.getRequestUrl(ECHO_RESPONSE), new HttpHeaders(), requestBody);
        HttpResponse httpResponse = this.createHttpClient().sendSync(request, Context.NONE);
        byte[] responseBytes = (byte[])httpResponse.getBodyAsByteArray().block();
        Assertions.assertArrayEquals((byte[])expectedResponseBody, (byte[])responseBytes);
    }

    @ParameterizedTest
    @MethodSource(value={"getBinaryDataBodyVariants"})
    public void canSendBinaryDataWithProgressReporting(BinaryData requestBody, byte[] expectedResponseBody) {
        HttpRequest request = new HttpRequest(HttpMethod.PUT, this.getRequestUrl(ECHO_RESPONSE), new HttpHeaders(), requestBody);
        AtomicLong progress = new AtomicLong();
        Context context = Contexts.empty().setHttpRequestProgressReporter(ProgressReporter.withProgressListener(progress::set)).getContext();
        StepVerifier.create((Publisher)this.createHttpClient().send(request, context).flatMap(HttpResponse::getBodyAsByteArray)).assertNext(responseBytes -> Assertions.assertArrayEquals((byte[])expectedResponseBody, (byte[])responseBytes)).verifyComplete();
        Assertions.assertEquals((int)expectedResponseBody.length, (int)progress.intValue());
    }

    @ParameterizedTest
    @MethodSource(value={"getBinaryDataBodyVariants"})
    public void canSendBinaryDataWithProgressReportingSync(BinaryData requestBody, byte[] expectedResponseBody) {
        HttpRequest request = new HttpRequest(HttpMethod.PUT, this.getRequestUrl(ECHO_RESPONSE), new HttpHeaders(), requestBody);
        AtomicLong progress = new AtomicLong();
        Context context = Contexts.empty().setHttpRequestProgressReporter(ProgressReporter.withProgressListener(progress::set)).getContext();
        HttpResponse httpResponse = this.createHttpClient().sendSync(request, context);
        byte[] responseBytes = (byte[])httpResponse.getBodyAsByteArray().block();
        Assertions.assertArrayEquals((byte[])expectedResponseBody, (byte[])responseBytes);
        Assertions.assertEquals((int)expectedResponseBody.length, (int)progress.intValue());
    }

    private static Stream<Arguments> getBinaryDataBodyVariants() {
        return Stream.of(1, 2, 10, 127, 1024, 1181, 8195, 0xA0000D).flatMap(size -> {
            try {
                byte[] bytes = new byte[size.intValue()];
                RANDOM.nextBytes(bytes);
                BinaryData byteArrayData = BinaryData.fromBytes((byte[])bytes);
                String randomString = new String(bytes, StandardCharsets.UTF_8);
                byte[] randomStringBytes = randomString.getBytes(StandardCharsets.UTF_8);
                BinaryData stringBinaryData = BinaryData.fromString((String)randomString);
                BinaryData streamData = BinaryData.fromStream((InputStream)new ByteArrayInputStream(bytes));
                ArrayList<ByteBuffer> bufferList = new ArrayList<ByteBuffer>();
                int bufferSize = 113;
                for (int startIndex = 0; startIndex < bytes.length; startIndex += bufferSize) {
                    bufferList.add(ByteBuffer.wrap(bytes, startIndex, Math.min(bytes.length - startIndex, bufferSize)));
                }
                BinaryData fluxBinaryData = (BinaryData)BinaryData.fromFlux((Flux)Flux.fromIterable(bufferList).map(ByteBuffer::duplicate), null, (boolean)false).block();
                BinaryData fluxBinaryDataWithLength = (BinaryData)BinaryData.fromFlux((Flux)Flux.fromIterable(bufferList).map(ByteBuffer::duplicate), (Long)size.longValue(), (boolean)false).block();
                BinaryData asyncFluxBinaryData = (BinaryData)BinaryData.fromFlux((Flux)Flux.fromIterable(bufferList).map(ByteBuffer::duplicate).delayElements(Duration.ofNanos(10L)).flatMapSequential(buffer -> Mono.delay((Duration)Duration.ofNanos(10L)).map(i -> buffer)), null, (boolean)false).block();
                BinaryData asyncFluxBinaryDataWithLength = (BinaryData)BinaryData.fromFlux((Flux)Flux.fromIterable(bufferList).map(ByteBuffer::duplicate).delayElements(Duration.ofNanos(10L)).flatMapSequential(buffer -> Mono.delay((Duration)Duration.ofNanos(10L)).map(i -> buffer)), (Long)size.longValue(), (boolean)false).block();
                BinaryData objectBinaryData = BinaryData.fromObject((Object)bytes, (ObjectSerializer)new ByteArraySerializer());
                Path wholeFile = Files.createTempFile("http-client-tests", null, new FileAttribute[0]);
                wholeFile.toFile().deleteOnExit();
                Files.write(wholeFile, bytes, new OpenOption[0]);
                BinaryData fileData = BinaryData.fromFile((Path)wholeFile);
                Path sliceFile = Files.createTempFile("http-client-tests", null, new FileAttribute[0]);
                sliceFile.toFile().deleteOnExit();
                Files.write(sliceFile, new byte[size.intValue()], StandardOpenOption.APPEND);
                Files.write(sliceFile, bytes, StandardOpenOption.APPEND);
                Files.write(sliceFile, new byte[size.intValue()], StandardOpenOption.APPEND);
                BinaryData sliceFileData = BinaryData.fromFile((Path)sliceFile, (Long)((Object)size), (Long)((Object)size));
                return Stream.of(Arguments.of((Object[])new Object[]{Named.named((String)"byte[]", (Object)byteArrayData), Named.named((String)("" + size), (Object)bytes)}), Arguments.of((Object[])new Object[]{Named.named((String)"String", (Object)stringBinaryData), Named.named((String)("" + randomStringBytes.length), (Object)randomStringBytes)}), Arguments.of((Object[])new Object[]{Named.named((String)"InputStream", (Object)streamData), Named.named((String)("" + size), (Object)bytes)}), Arguments.of((Object[])new Object[]{Named.named((String)"Flux", (Object)fluxBinaryData), Named.named((String)("" + size), (Object)bytes)}), Arguments.of((Object[])new Object[]{Named.named((String)"Flux with length", (Object)fluxBinaryDataWithLength), Named.named((String)("" + size), (Object)bytes)}), Arguments.of((Object[])new Object[]{Named.named((String)"async Flux", (Object)asyncFluxBinaryData), Named.named((String)("" + size), (Object)bytes)}), Arguments.of((Object[])new Object[]{Named.named((String)"async Flux with length", (Object)asyncFluxBinaryDataWithLength), Named.named((String)("" + size), (Object)bytes)}), Arguments.of((Object[])new Object[]{Named.named((String)"Object", (Object)objectBinaryData), Named.named((String)("" + size), (Object)bytes)}), Arguments.of((Object[])new Object[]{Named.named((String)"File", (Object)fileData), Named.named((String)("" + size), (Object)bytes)}), Arguments.of((Object[])new Object[]{Named.named((String)"File slice", (Object)sliceFileData), Named.named((String)("" + size), (Object)bytes)}));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    private Mono<String> sendRequest(String requestPath) {
        return this.createHttpClient().send(new HttpRequest(HttpMethod.GET, this.getRequestUrl(requestPath))).flatMap(HttpResponse::getBodyAsString);
    }

    private String sendRequestSync(String requestPath) {
        HttpResponse httpResponse = this.createHttpClient().sendSync(new HttpRequest(HttpMethod.GET, this.getRequestUrl(requestPath)), Context.NONE);
        return (String)httpResponse.getBodyAsString().block();
    }

    protected URL getRequestUrl(String requestPath) {
        try {
            String prefix = this.isSecure() ? "https://" : "http://";
            return new URL(prefix + REQUEST_HOST + ":" + this.getWireMockPort() + "/" + requestPath);
        }
        catch (MalformedURLException e) {
            throw LOGGER.logExceptionAsError(new RuntimeException(e));
        }
    }

    private static class ByteArraySerializer
    implements ObjectSerializer {
        private ByteArraySerializer() {
        }

        public <T> T deserialize(InputStream stream, TypeReference<T> typeReference) {
            throw new UnsupportedOperationException("Not supported");
        }

        public <T> Mono<T> deserializeAsync(InputStream stream, TypeReference<T> typeReference) {
            throw new UnsupportedOperationException("Not supported");
        }

        public void serialize(OutputStream stream, Object value) {
            try {
                stream.write((byte[])value);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public Mono<Void> serializeAsync(OutputStream stream, Object value) {
            return Mono.fromRunnable(() -> this.serialize(stream, value));
        }
    }
}

