/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.test;

import com.azure.core.test.TestMode;
import com.azure.core.test.annotation.DoNotRecord;
import java.lang.reflect.Method;
import org.junit.jupiter.api.Assumptions;

public class TestContextManager {
    private final String testName;
    private final String className;
    private final TestMode testMode;
    private final boolean doNotRecord;
    private final boolean testRan;
    private Integer testIteration;

    public TestContextManager(Method testMethod, TestMode testMode) {
        boolean skipInPlayback;
        this.testName = testMethod.getName();
        this.className = testMethod.getDeclaringClass().getSimpleName();
        this.testMode = testMode;
        DoNotRecord doNotRecordAnnotation = testMethod.getAnnotation(DoNotRecord.class);
        if (doNotRecordAnnotation != null) {
            this.doNotRecord = true;
            skipInPlayback = doNotRecordAnnotation.skipInPlayback();
        } else {
            this.doNotRecord = false;
            skipInPlayback = false;
        }
        this.testRan = !skipInPlayback || testMode != TestMode.PLAYBACK;
        Assumptions.assumeTrue((boolean)this.testRan, (String)"Test does not allow playback and was ran in 'TestMode.PLAYBACK'");
    }

    public String getTestName() {
        return this.testName;
    }

    public String getTestPlaybackRecordingName() {
        StringBuilder builder = new StringBuilder(this.className).append(".").append(this.testName);
        if (this.testIteration != null) {
            builder.append("[").append(this.testIteration).append("]");
        }
        return builder.toString();
    }

    public TestMode getTestMode() {
        return this.testMode;
    }

    public boolean doNotRecordTest() {
        return this.doNotRecord;
    }

    public boolean didTestRun() {
        return this.testRan;
    }

    void setTestIteration(Integer testIteration) {
        this.testIteration = testIteration;
    }
}

