/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.test;

import com.azure.core.test.implementation.TestRunMetrics;
import com.azure.core.util.Configuration;
import java.lang.reflect.Method;
import java.util.Objects;
import java.util.function.Supplier;
import org.junit.jupiter.api.extension.AfterTestExecutionCallback;
import org.junit.jupiter.api.extension.BeforeTestExecutionCallback;
import org.junit.jupiter.api.extension.ExtensionContext;

public class AzureTestWatcher
implements BeforeTestExecutionCallback,
AfterTestExecutionCallback {
    private static final String AZURE_TEST_DEBUG = "AZURE_TEST_DEBUG";
    private static final Supplier<Boolean> SHOULD_LOG_EXECUTION_STATUS = () -> Boolean.parseBoolean(Configuration.getGlobalConfiguration().get(AZURE_TEST_DEBUG));

    public void beforeTestExecution(ExtensionContext extensionContext) {
        if (!SHOULD_LOG_EXECUTION_STATUS.get().booleanValue()) {
            return;
        }
        String displayName = extensionContext.getDisplayName();
        String testName = "";
        String fullyQualifiedTestName = "";
        if (extensionContext.getTestMethod().isPresent()) {
            Method method = (Method)extensionContext.getTestMethod().get();
            testName = method.getName();
            fullyQualifiedTestName = method.getDeclaringClass().getName() + "." + testName;
        }
        StringBuilder logPrefixBuilder = new StringBuilder("Starting test ").append(fullyQualifiedTestName);
        if (!Objects.equals(displayName, testName)) {
            logPrefixBuilder.append("(").append(displayName).append(")");
        }
        logPrefixBuilder.append(",");
        AzureTestWatcher.getStore(extensionContext).put((Object)extensionContext.getRequiredTestMethod(), (Object)new TestRunMetrics(logPrefixBuilder.toString(), System.currentTimeMillis()));
    }

    public void afterTestExecution(ExtensionContext context) {
        if (!SHOULD_LOG_EXECUTION_STATUS.get().booleanValue()) {
            return;
        }
        TestRunMetrics testInformation = (TestRunMetrics)AzureTestWatcher.getStore(context).remove((Object)context.getRequiredTestMethod(), TestRunMetrics.class);
        long duration = System.currentTimeMillis() - testInformation.getStartMillis();
        System.out.printf("%s completed in %d ms.%n", testInformation.getLogPrefix(), duration);
    }

    private static ExtensionContext.Store getStore(ExtensionContext context) {
        return context.getStore(ExtensionContext.Namespace.create((Object[])new Object[]{AzureTestWatcher.class, context}));
    }
}

