/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.amqp.models;

import com.azure.core.amqp.models.AmqpMessageBodyType;
import com.azure.core.util.IterableStream;
import com.azure.core.util.logging.ClientLogger;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;

public final class AmqpMessageBody {
    private final ClientLogger logger = new ClientLogger(AmqpMessageBody.class);
    private AmqpMessageBodyType bodyType;
    private byte[] data;
    private List<byte[]> dataList;
    private Object value;
    private List<Object> sequence;

    private AmqpMessageBody() {
    }

    public static AmqpMessageBody fromData(byte[] data) {
        Objects.requireNonNull(data, "'data' cannot be null.");
        AmqpMessageBody body = new AmqpMessageBody();
        body.bodyType = AmqpMessageBodyType.DATA;
        body.data = data;
        return body;
    }

    public static AmqpMessageBody fromSequence(List<Object> sequence) {
        Objects.requireNonNull(sequence, "'sequence' cannot be null.");
        AmqpMessageBody body = new AmqpMessageBody();
        body.bodyType = AmqpMessageBodyType.SEQUENCE;
        body.sequence = sequence;
        return body;
    }

    public static AmqpMessageBody fromValue(Object value) {
        Objects.requireNonNull(value, "'value' cannot be null.");
        AmqpMessageBody body = new AmqpMessageBody();
        body.bodyType = AmqpMessageBodyType.VALUE;
        body.value = value;
        return body;
    }

    public AmqpMessageBodyType getBodyType() {
        return this.bodyType;
    }

    public IterableStream<byte[]> getData() {
        if (this.bodyType != AmqpMessageBodyType.DATA) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("This method can only be called if AMQP Message body type is 'DATA'."));
        }
        if (this.dataList == null) {
            this.dataList = Collections.singletonList(this.data);
        }
        return new IterableStream(this.dataList);
    }

    public byte[] getFirstData() {
        if (this.bodyType != AmqpMessageBodyType.DATA) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format(Locale.US, "This method can be called if AMQP Message body type is 'DATA'. The actual type is [%s].", new Object[]{this.bodyType})));
        }
        return this.data;
    }

    public List<Object> getSequence() {
        if (this.bodyType != AmqpMessageBodyType.SEQUENCE) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format(Locale.US, "This method can be called if AMQP Message body type is 'SEQUENCE'. The actual type is [%s].", new Object[]{this.bodyType})));
        }
        return Collections.unmodifiableList(this.sequence);
    }

    public Object getValue() {
        if (this.bodyType != AmqpMessageBodyType.VALUE) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format(Locale.US, "This method can be called if AMQP Message body type is 'VALUE'. The actual type is [%s].", new Object[]{this.bodyType})));
        }
        return this.value;
    }
}

