/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.amqp.implementation.handler;

import com.azure.core.amqp.implementation.handler.LinkHandler;
import com.azure.core.util.logging.ClientLogger;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.qpid.proton.engine.Delivery;
import org.apache.qpid.proton.engine.EndpointState;
import org.apache.qpid.proton.engine.Event;
import org.apache.qpid.proton.engine.Link;
import org.apache.qpid.proton.engine.Sender;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Sinks;

public class SendLinkHandler
extends LinkHandler {
    private final String linkName;
    private final String entityPath;
    private final AtomicBoolean isFirstFlow = new AtomicBoolean(true);
    private final AtomicBoolean isTerminated = new AtomicBoolean();
    private final Sinks.Many<Integer> creditProcessor = Sinks.many().unicast().onBackpressureBuffer();
    private final Sinks.Many<Delivery> deliveryProcessor = Sinks.many().multicast().onBackpressureBuffer();

    public SendLinkHandler(String connectionId, String hostname, String linkName, String entityPath) {
        super(connectionId, hostname, entityPath, new ClientLogger(SendLinkHandler.class));
        this.linkName = linkName;
        this.entityPath = entityPath;
    }

    public String getLinkName() {
        return this.linkName;
    }

    public Flux<Integer> getLinkCredits() {
        return this.creditProcessor.asFlux();
    }

    public Flux<Delivery> getDeliveredMessages() {
        return this.deliveryProcessor.asFlux();
    }

    @Override
    public void close() {
        if (this.isTerminated.getAndSet(true)) {
            return;
        }
        this.creditProcessor.emitComplete(Sinks.EmitFailureHandler.FAIL_FAST);
        this.deliveryProcessor.emitComplete((signalType, emitResult) -> {
            this.logger.verbose("connectionId[{}] linkName[{}] result[{}] Unable to emit complete on deliverySink.", new Object[]{this.getConnectionId(), this.linkName, emitResult});
            return false;
        });
        super.close();
    }

    public void onLinkLocalOpen(Event event) {
        Link link = event.getLink();
        if (link instanceof Sender) {
            this.logger.verbose("onLinkLocalOpen connectionId[{}], entityPath[{}], linkName[{}], localTarget[{}]", new Object[]{this.getConnectionId(), this.entityPath, link.getName(), link.getTarget()});
        }
    }

    public void onLinkRemoteOpen(Event event) {
        Link link = event.getLink();
        if (!(link instanceof Sender)) {
            return;
        }
        if (link.getRemoteTarget() != null) {
            this.logger.info("onLinkRemoteOpen connectionId[{}], entityPath[{}], linkName[{}], remoteTarget[{}]", new Object[]{this.getConnectionId(), this.entityPath, link.getName(), link.getRemoteTarget()});
            if (this.isFirstFlow.getAndSet(false)) {
                this.onNext(EndpointState.ACTIVE);
            }
        } else {
            this.logger.info("onLinkRemoteOpen connectionId[{}], entityPath[{}], linkName[{}], remoteTarget[null], remoteSource[null], action[waitingForError]", new Object[]{this.getConnectionId(), this.entityPath, link.getName()});
        }
    }

    public void onLinkFlow(Event event) {
        if (this.isFirstFlow.getAndSet(false)) {
            this.onNext(EndpointState.ACTIVE);
        }
        Sender sender = event.getSender();
        int credits = sender.getRemoteCredit();
        this.creditProcessor.emitNext((Object)credits, (signalType, emitResult) -> {
            this.logger.verbose("connectionId[{}] linkName[{}] result[{}] Unable to emit credits [{}].", new Object[]{this.getConnectionId(), this.linkName, emitResult, credits});
            return false;
        });
        this.logger.verbose("onLinkFlow connectionId[{}] linkName[{}] unsettled[{}] credit[{}]", new Object[]{this.getConnectionId(), sender.getName(), sender.getUnsettled(), sender.getCredit()});
    }

    public void onDelivery(Event event) {
        Delivery delivery = event.getDelivery();
        while (delivery != null) {
            Sender sender = (Sender)delivery.getLink();
            String deliveryTag = new String(delivery.getTag(), StandardCharsets.UTF_8);
            this.logger.verbose("onDelivery connectionId[{}] linkName[{}] unsettled[{}] credit[{}], deliveryState[{}] delivery.isBuffered[{}] delivery.id[{}]", new Object[]{this.getConnectionId(), sender.getName(), sender.getUnsettled(), sender.getRemoteCredit(), delivery.getRemoteState(), delivery.isBuffered(), deliveryTag});
            this.deliveryProcessor.emitNext((Object)delivery, (signalType, emitResult) -> {
                this.logger.warning("connectionId[{}] linkName[{}] result[{}] Unable to emit delivery [{}].", new Object[]{this.getConnectionId(), this.linkName, emitResult, deliveryTag});
                return emitResult == Sinks.EmitResult.FAIL_OVERFLOW;
            });
            delivery.settle();
            delivery = sender.current();
        }
    }
}

