/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.amqp.implementation;

import com.azure.core.amqp.AmqpEndpointState;
import com.azure.core.amqp.AmqpRetryPolicy;
import com.azure.core.amqp.exception.AmqpException;
import com.azure.core.util.logging.ClientLogger;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.Consumer;
import java.util.function.Function;
import org.reactivestreams.Processor;
import org.reactivestreams.Subscription;
import reactor.core.CoreSubscriber;
import reactor.core.Disposable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Operators;
import reactor.util.context.Context;

public class AmqpChannelProcessor<T>
extends Mono<T>
implements Processor<T, T>,
CoreSubscriber<T>,
Disposable {
    private static final AtomicReferenceFieldUpdater<AmqpChannelProcessor, Subscription> UPSTREAM = AtomicReferenceFieldUpdater.newUpdater(AmqpChannelProcessor.class, Subscription.class, "upstream");
    private final ClientLogger logger;
    private final AtomicBoolean isDisposed = new AtomicBoolean();
    private final AtomicBoolean isRequested = new AtomicBoolean();
    private final AtomicBoolean isRetryPending = new AtomicBoolean();
    private final AtomicInteger retryAttempts = new AtomicInteger();
    private final Object lock = new Object();
    private final AmqpRetryPolicy retryPolicy;
    private final String fullyQualifiedNamespace;
    private final String entityPath;
    private final Function<T, Flux<AmqpEndpointState>> endpointStatesFunction;
    private volatile Subscription upstream;
    private volatile ConcurrentLinkedDeque<ChannelSubscriber<T>> subscribers = new ConcurrentLinkedDeque();
    private volatile Throwable lastError;
    private volatile T currentChannel;
    private volatile Disposable connectionSubscription;
    private volatile Disposable retrySubscription;

    public AmqpChannelProcessor(String fullyQualifiedNamespace, String entityPath, Function<T, Flux<AmqpEndpointState>> endpointStatesFunction, AmqpRetryPolicy retryPolicy, ClientLogger logger) {
        this.fullyQualifiedNamespace = Objects.requireNonNull(fullyQualifiedNamespace, "'fullyQualifiedNamespace' cannot be null.");
        this.entityPath = Objects.requireNonNull(entityPath, "'entityPath' cannot be null.");
        this.endpointStatesFunction = Objects.requireNonNull(endpointStatesFunction, "'endpointStates' cannot be null.");
        this.retryPolicy = Objects.requireNonNull(retryPolicy, "'retryPolicy' cannot be null.");
        this.logger = Objects.requireNonNull(logger, "'logger' cannot be null.");
    }

    public void onSubscribe(Subscription subscription) {
        if (Operators.setOnce(UPSTREAM, (Object)((Object)this), (Subscription)subscription)) {
            this.isRequested.set(true);
            subscription.request(1L);
        } else {
            this.logger.warning("Processors can only be subscribed to once.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onNext(T amqpChannel) {
        Disposable oldSubscription;
        T oldChannel;
        this.logger.info("namespace[{}] entityPath[{}]: Setting next AMQP channel.", new Object[]{this.fullyQualifiedNamespace, this.entityPath});
        Objects.requireNonNull(amqpChannel, "'amqpChannel' cannot be null.");
        Object object = this.lock;
        synchronized (object) {
            oldChannel = this.currentChannel;
            oldSubscription = this.connectionSubscription;
            this.currentChannel = amqpChannel;
            ConcurrentLinkedDeque<ChannelSubscriber<T>> currentSubscribers = this.subscribers;
            this.logger.info("namespace[{}] entityPath[{}]: Next AMQP channel received, updating {} current subscribers", new Object[]{this.fullyQualifiedNamespace, this.entityPath, this.subscribers.size()});
            currentSubscribers.forEach((Consumer<ChannelSubscriber<T>>)((Consumer<ChannelSubscriber>)subscription -> subscription.onNext(amqpChannel)));
            this.connectionSubscription = this.endpointStatesFunction.apply(amqpChannel).subscribe(state -> {
                if (state == AmqpEndpointState.ACTIVE) {
                    this.retryAttempts.set(0);
                    this.logger.info("namespace[{}] entityPath[{}]: Channel is now active.", new Object[]{this.fullyQualifiedNamespace, this.entityPath});
                }
            }, error -> {
                this.setAndClearChannel();
                this.onError((Throwable)error);
            }, () -> {
                if (this.isDisposed()) {
                    this.logger.info("namespace[{}] entityPath[{}]: Channel is disposed.", new Object[]{this.fullyQualifiedNamespace, this.entityPath});
                } else {
                    this.logger.info("namespace[{}] entityPath[{}]: Channel is closed.", new Object[]{this.fullyQualifiedNamespace, this.entityPath});
                    this.setAndClearChannel();
                }
            });
        }
        this.close(oldChannel);
        if (oldSubscription != null) {
            oldSubscription.dispose();
        }
        this.isRequested.set(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onError(Throwable throwable) {
        int attempt;
        Duration retryInterval;
        AmqpException amqpException;
        Objects.requireNonNull(throwable, "'throwable' is required.");
        if (this.isRetryPending.get() && this.retryPolicy.calculateRetryDelay(throwable, this.retryAttempts.get()) != null) {
            this.logger.warning("Retry is already pending. Ignoring transient error.", new Object[]{throwable});
            return;
        }
        int attemptsMade = this.retryAttempts.incrementAndGet();
        if (throwable instanceof AmqpException && (amqpException = (AmqpException)((Object)throwable)).isTransient()) {
            this.logger.verbose("Attempted {} times to get a new AMQP connection", new Object[]{attemptsMade});
            attemptsMade = Math.min(attemptsMade, this.retryPolicy.getMaxRetries());
        }
        if ((retryInterval = this.retryPolicy.calculateRetryDelay(throwable, attempt = attemptsMade)) != null) {
            if (this.isRetryPending.getAndSet(true)) {
                this.retryAttempts.decrementAndGet();
                return;
            }
            this.logger.warning("Retry #{}. Transient error occurred. Retrying after {} ms.", new Object[]{attempt, retryInterval.toMillis(), throwable});
            this.retrySubscription = Mono.delay((Duration)retryInterval).subscribe(i -> {
                if (this.isDisposed()) {
                    this.logger.info("Retry #{}. Not requesting from upstream. Processor is disposed.", new Object[]{attempt});
                } else {
                    this.logger.info("Retry #{}. Requesting from upstream.", new Object[]{attempt});
                    this.requestUpstream();
                    this.isRetryPending.set(false);
                }
            });
            return;
        }
        this.logger.warning("Non-retryable error occurred in connection.", new Object[]{throwable});
        this.lastError = throwable;
        this.isDisposed.set(true);
        this.dispose();
        Object object = this.lock;
        synchronized (object) {
            ConcurrentLinkedDeque<ChannelSubscriber<T>> currentSubscribers = this.subscribers;
            this.subscribers = new ConcurrentLinkedDeque();
            this.logger.info("namespace[{}] entityPath[{}]: Error in AMQP channel processor. Notifying {} subscribers.", new Object[]{this.fullyQualifiedNamespace, this.entityPath, currentSubscribers.size()});
            currentSubscribers.forEach((Consumer<ChannelSubscriber<T>>)((Consumer<ChannelSubscriber>)subscriber -> subscriber.onError(throwable)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onComplete() {
        this.logger.info("Upstream connection publisher was completed. Terminating processor.");
        this.isDisposed.set(true);
        Object object = this.lock;
        synchronized (object) {
            ConcurrentLinkedDeque<ChannelSubscriber<T>> currentSubscribers = this.subscribers;
            this.subscribers = new ConcurrentLinkedDeque();
            this.logger.info("namespace[{}] entityPath[{}]: AMQP channel processor completed. Notifying {} subscribers.", new Object[]{this.fullyQualifiedNamespace, this.entityPath, currentSubscribers.size()});
            currentSubscribers.forEach((Consumer<ChannelSubscriber<T>>)((Consumer<ChannelSubscriber>)subscriber -> subscriber.onComplete()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subscribe(CoreSubscriber<? super T> actual) {
        if (this.isDisposed()) {
            if (this.lastError != null) {
                actual.onSubscribe(Operators.emptySubscription());
                actual.onError(this.lastError);
            } else {
                Operators.error(actual, (Throwable)this.logger.logExceptionAsError((RuntimeException)new IllegalStateException(String.format("namespace[%s] entityPath[%s]: Cannot subscribe. Processor is already terminated.", this.fullyQualifiedNamespace, this.entityPath))));
            }
            return;
        }
        ChannelSubscriber subscriber = new ChannelSubscriber(actual, this);
        actual.onSubscribe(subscriber);
        Object object = this.lock;
        synchronized (object) {
            if (this.currentChannel != null) {
                subscriber.complete(this.currentChannel);
                return;
            }
        }
        this.subscribers.add(subscriber);
        this.logger.verbose("Added a subscriber {} to AMQP channel processor. Total subscribers = {}", new Object[]{subscriber, this.subscribers.size()});
        if (!this.isRetryPending.get()) {
            this.requestUpstream();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        if (this.isDisposed.getAndSet(true)) {
            return;
        }
        if (this.retrySubscription != null && !this.retrySubscription.isDisposed()) {
            this.retrySubscription.dispose();
        }
        this.onComplete();
        Object object = this.lock;
        synchronized (object) {
            this.setAndClearChannel();
        }
    }

    public boolean isDisposed() {
        return this.isDisposed.get();
    }

    private void requestUpstream() {
        if (this.currentChannel != null) {
            this.logger.verbose("namespace[{}] entityPath[{}]: Connection exists, not requesting another.", new Object[]{this.fullyQualifiedNamespace, this.entityPath});
            return;
        }
        if (this.isDisposed()) {
            this.logger.verbose("namespace[{}] entityPath[{}]: Is already disposed.", new Object[]{this.fullyQualifiedNamespace, this.entityPath});
            return;
        }
        Subscription subscription = UPSTREAM.get(this);
        if (subscription == null) {
            this.logger.warning("namespace[{}] entityPath[{}]: There is no upstream subscription.", new Object[]{this.fullyQualifiedNamespace, this.entityPath});
            return;
        }
        if (!this.isRequested.getAndSet(true)) {
            this.logger.info("namespace[{}] entityPath[{}]: Connection not requested, yet. Requesting one.", new Object[]{this.fullyQualifiedNamespace, this.entityPath});
            subscription.request(1L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setAndClearChannel() {
        T oldChannel;
        Object object = this.lock;
        synchronized (object) {
            oldChannel = this.currentChannel;
            this.currentChannel = null;
        }
        this.close(oldChannel);
    }

    private void close(T channel) {
        if (channel instanceof AutoCloseable) {
            try {
                ((AutoCloseable)channel).close();
            }
            catch (Exception error) {
                this.logger.warning("Error occurred closing AutoCloseable channel.", new Object[]{error});
            }
        } else if (channel instanceof Disposable) {
            try {
                ((Disposable)channel).dispose();
            }
            catch (Exception error) {
                this.logger.warning("Error occurred closing Disposable channel.", new Object[]{error});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isChannelClosed() {
        Object object = this.lock;
        synchronized (object) {
            return this.currentChannel == null || this.isDisposed();
        }
    }

    private static final class ChannelSubscriber<T>
    extends Operators.MonoSubscriber<T, T> {
        private final AmqpChannelProcessor<T> processor;

        private ChannelSubscriber(CoreSubscriber<? super T> actual, AmqpChannelProcessor<T> processor) {
            super(actual);
            this.processor = processor;
        }

        public void cancel() {
            super.cancel();
            ((AmqpChannelProcessor)this.processor).subscribers.remove((Object)this);
        }

        public void onComplete() {
            if (!this.isCancelled()) {
                this.actual.onComplete();
            }
        }

        public void onNext(T channel) {
            if (!this.isCancelled()) {
                super.complete(channel);
            }
        }

        public void onError(Throwable throwable) {
            if (!this.isCancelled()) {
                this.actual.onError(throwable);
            } else {
                Operators.onOperatorError((Throwable)throwable, (Context)this.currentContext());
            }
        }
    }
}

