/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.callautomation.models.events;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class ResultInformation
implements JsonSerializable<ResultInformation> {
    private final Integer code;
    private final Integer subCode;
    private final String message;

    private ResultInformation(Integer code, Integer subCode, String message) {
        this.code = code;
        this.subCode = subCode;
        this.message = message;
    }

    public Integer getCode() {
        return this.code;
    }

    public Integer getSubCode() {
        return this.subCode;
    }

    public String getMessage() {
        return this.message;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("code", (Number)this.code);
        jsonWriter.writeNumberField("subCode", (Number)this.subCode);
        jsonWriter.writeStringField("message", this.message);
        return jsonWriter.writeEndObject();
    }

    public static ResultInformation fromJson(JsonReader jsonReader) throws IOException {
        return (ResultInformation)jsonReader.readObject(reader -> {
            Integer code = null;
            Integer subCode = null;
            String message = null;
            while (jsonReader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("code".equals(fieldName)) {
                    code = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("subCode".equals(fieldName)) {
                    subCode = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("message".equals(fieldName)) {
                    message = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return new ResultInformation(code, subCode, message);
        });
    }
}

