/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.callautomation.models.events;

import com.azure.communication.callautomation.implementation.converters.CallParticipantConverter;
import com.azure.communication.callautomation.implementation.converters.CommunicationIdentifierConverter;
import com.azure.communication.callautomation.implementation.models.CallParticipantInternal;
import com.azure.communication.callautomation.models.CallParticipant;
import com.azure.communication.callautomation.models.events.CallAutomationEventBase;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;

public final class ParticipantsUpdated
extends CallAutomationEventBase {
    private List<CallParticipant> participants;
    private int sequenceNumber;

    private ParticipantsUpdated() {
    }

    public List<CallParticipant> getParticipants() {
        return this.participants;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("sequenceNumber", (Number)this.sequenceNumber);
        jsonWriter.writeStartArray("participants");
        for (CallParticipant participant : this.participants) {
            CallParticipantInternal inner = new CallParticipantInternal();
            inner.setIdentifier(CommunicationIdentifierConverter.convert(participant.getIdentifier()));
            inner.setIsMuted(participant.isMuted());
            inner.setIsOnHold(participant.isOnHold());
            jsonWriter.writeJson((JsonSerializable)inner);
        }
        jsonWriter.writeEndArray();
        super.writeFields(jsonWriter);
        return jsonWriter.writeEndObject();
    }

    public static ParticipantsUpdated fromJson(JsonReader jsonReader) throws IOException {
        return (ParticipantsUpdated)jsonReader.readObject(reader -> {
            ParticipantsUpdated event = new ParticipantsUpdated();
            while (jsonReader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("sequenceNumber".equals(fieldName)) {
                    event.sequenceNumber = reader.getInt();
                    continue;
                }
                if ("participants".equals(fieldName)) {
                    event.participants = reader.readArray(CallParticipantInternal::fromJson).stream().map(CallParticipantConverter::convert).collect(Collectors.toList());
                    continue;
                }
                if (event.readField(fieldName, (JsonReader)reader)) continue;
                reader.skipChildren();
            }
            return event;
        });
    }
}

