/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.callautomation.models.events;

import com.azure.communication.callautomation.implementation.converters.CommunicationIdentifierConverter;
import com.azure.communication.callautomation.implementation.models.CommunicationIdentifierModel;
import com.azure.communication.callautomation.models.events.CallAutomationEventBase;
import com.azure.communication.callautomation.models.events.ResultInformation;
import com.azure.communication.common.CommunicationIdentifier;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class CallTransferAccepted
extends CallAutomationEventBase {
    private ResultInformation resultInformation;
    private CommunicationIdentifier transferee;
    private CommunicationIdentifier transferTarget;

    private CallTransferAccepted() {
    }

    public CommunicationIdentifier getTransferee() {
        return this.transferee;
    }

    public CommunicationIdentifier getTransferTarget() {
        return this.transferTarget;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("transferee", (JsonSerializable)CommunicationIdentifierConverter.convert(this.transferee));
        jsonWriter.writeJsonField("transferTarget", (JsonSerializable)CommunicationIdentifierConverter.convert(this.transferTarget));
        super.writeFields(jsonWriter);
        return jsonWriter.writeEndObject();
    }

    public static CallTransferAccepted fromJson(JsonReader jsonReader) throws IOException {
        return (CallTransferAccepted)jsonReader.readObject(reader -> {
            CallTransferAccepted event = new CallTransferAccepted();
            while (jsonReader.nextToken() != JsonToken.END_OBJECT) {
                CommunicationIdentifierModel inner;
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("transferee".equals(fieldName)) {
                    inner = CommunicationIdentifierModel.fromJson(reader);
                    event.transferee = CommunicationIdentifierConverter.convert(inner);
                    continue;
                }
                if ("transferTarget".equals(fieldName)) {
                    inner = CommunicationIdentifierModel.fromJson(reader);
                    event.transferTarget = CommunicationIdentifierConverter.convert(inner);
                    continue;
                }
                if (event.readField(fieldName, (JsonReader)reader)) continue;
                reader.skipChildren();
            }
            return event;
        });
    }
}

