/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.callautomation.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.Duration;

public class WordData
implements JsonSerializable<WordData> {
    private String text;
    private long offset;
    private long duration;

    public String getText() {
        return this.text;
    }

    public long getOffset() {
        return this.offset;
    }

    public Duration getDuration() {
        return Duration.ofNanos(this.duration * 100L);
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("text", this.text);
        jsonWriter.writeLongField("offset", this.offset);
        jsonWriter.writeLongField("duration", this.duration);
        return jsonWriter.writeEndObject();
    }

    public static WordData fromJson(JsonReader jsonReader) throws IOException {
        return (WordData)jsonReader.readObject(reader -> {
            WordData word = new WordData();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("text".equals(fieldName)) {
                    word.text = reader.getString();
                    continue;
                }
                if ("offset".equals(fieldName)) {
                    word.offset = reader.getLong();
                    continue;
                }
                if ("duration".equals(fieldName)) {
                    word.duration = reader.getLong();
                    continue;
                }
                reader.skipChildren();
            }
            return word;
        });
    }
}

