/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.callautomation.models;

import com.azure.communication.callautomation.models.DtmfTone;
import com.azure.communication.callautomation.models.RecognizeResult;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;

public final class DtmfResult
extends RecognizeResult {
    private List<DtmfTone> dtmfTones;

    public List<DtmfTone> getTones() {
        return this.dtmfTones;
    }

    public DtmfResult setTones(List<DtmfTone> dtmfTones) {
        this.dtmfTones = dtmfTones;
        return this;
    }

    public String convertToString() {
        if (this.dtmfTones == null) {
            return "";
        }
        return this.dtmfTones.stream().map(x -> x.convertToString()).collect(Collectors.joining());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("tones", this.dtmfTones, (writer, element) -> writer.writeString(element.toString()));
        return jsonWriter.writeEndObject();
    }

    public static DtmfResult fromJson(JsonReader jsonReader) throws IOException {
        return (DtmfResult)jsonReader.readObject(reader -> {
            DtmfResult result = new DtmfResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("tones".equals(fieldName)) {
                    result.dtmfTones = reader.readArray(r -> DtmfTone.fromString(r.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return result;
        });
    }
}

