/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.callautomation.implementation.models;

import com.azure.communication.callautomation.implementation.models.TranscriptionResultType;
import com.azure.communication.callautomation.implementation.models.TranscriptionSubscriptionState;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class TranscriptionSubscription
implements JsonSerializable<TranscriptionSubscription> {
    private String id;
    private TranscriptionSubscriptionState state;
    private List<TranscriptionResultType> subscribedResultTypes;

    public String getId() {
        return this.id;
    }

    public TranscriptionSubscription setId(String id) {
        this.id = id;
        return this;
    }

    public TranscriptionSubscriptionState getState() {
        return this.state;
    }

    public TranscriptionSubscription setState(TranscriptionSubscriptionState state) {
        this.state = state;
        return this;
    }

    public List<TranscriptionResultType> getSubscribedResultTypes() {
        return this.subscribedResultTypes;
    }

    public TranscriptionSubscription setSubscribedResultTypes(List<TranscriptionResultType> subscribedResultTypes) {
        this.subscribedResultTypes = subscribedResultTypes;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeStringField("state", this.state == null ? null : this.state.toString());
        jsonWriter.writeArrayField("subscribedResultTypes", this.subscribedResultTypes, (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        return jsonWriter.writeEndObject();
    }

    public static TranscriptionSubscription fromJson(JsonReader jsonReader) throws IOException {
        return (TranscriptionSubscription)jsonReader.readObject(reader -> {
            TranscriptionSubscription deserializedTranscriptionSubscription = new TranscriptionSubscription();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedTranscriptionSubscription.id = reader.getString();
                    continue;
                }
                if ("state".equals(fieldName)) {
                    deserializedTranscriptionSubscription.state = TranscriptionSubscriptionState.fromString(reader.getString());
                    continue;
                }
                if ("subscribedResultTypes".equals(fieldName)) {
                    List subscribedResultTypes;
                    deserializedTranscriptionSubscription.subscribedResultTypes = subscribedResultTypes = reader.readArray(reader1 -> TranscriptionResultType.fromString(reader1.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedTranscriptionSubscription;
        });
    }
}

