/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.callautomation.implementation.models;

import com.azure.communication.callautomation.implementation.models.CommunicationIdentifierModel;
import com.azure.communication.callautomation.implementation.models.DtmfOptionsInternal;
import com.azure.communication.callautomation.implementation.models.RecognitionChoiceInternal;
import com.azure.communication.callautomation.implementation.models.SpeechOptionsInternal;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class RecognizeOptionsInternal
implements JsonSerializable<RecognizeOptionsInternal> {
    private Boolean interruptPrompt;
    private Integer initialSilenceTimeoutInSeconds;
    private CommunicationIdentifierModel targetParticipant;
    private String speechLanguage;
    private String speechRecognitionModelEndpointId;
    private DtmfOptionsInternal dtmfOptions;
    private List<RecognitionChoiceInternal> choices;
    private SpeechOptionsInternal speechOptions;

    public Boolean isInterruptPrompt() {
        return this.interruptPrompt;
    }

    public RecognizeOptionsInternal setInterruptPrompt(Boolean interruptPrompt) {
        this.interruptPrompt = interruptPrompt;
        return this;
    }

    public Integer getInitialSilenceTimeoutInSeconds() {
        return this.initialSilenceTimeoutInSeconds;
    }

    public RecognizeOptionsInternal setInitialSilenceTimeoutInSeconds(Integer initialSilenceTimeoutInSeconds) {
        this.initialSilenceTimeoutInSeconds = initialSilenceTimeoutInSeconds;
        return this;
    }

    public CommunicationIdentifierModel getTargetParticipant() {
        return this.targetParticipant;
    }

    public RecognizeOptionsInternal setTargetParticipant(CommunicationIdentifierModel targetParticipant) {
        this.targetParticipant = targetParticipant;
        return this;
    }

    public String getSpeechLanguage() {
        return this.speechLanguage;
    }

    public RecognizeOptionsInternal setSpeechLanguage(String speechLanguage) {
        this.speechLanguage = speechLanguage;
        return this;
    }

    public String getSpeechRecognitionModelEndpointId() {
        return this.speechRecognitionModelEndpointId;
    }

    public RecognizeOptionsInternal setSpeechRecognitionModelEndpointId(String speechRecognitionModelEndpointId) {
        this.speechRecognitionModelEndpointId = speechRecognitionModelEndpointId;
        return this;
    }

    public DtmfOptionsInternal getDtmfOptions() {
        return this.dtmfOptions;
    }

    public RecognizeOptionsInternal setDtmfOptions(DtmfOptionsInternal dtmfOptions) {
        this.dtmfOptions = dtmfOptions;
        return this;
    }

    public List<RecognitionChoiceInternal> getChoices() {
        return this.choices;
    }

    public RecognizeOptionsInternal setChoices(List<RecognitionChoiceInternal> choices) {
        this.choices = choices;
        return this;
    }

    public SpeechOptionsInternal getSpeechOptions() {
        return this.speechOptions;
    }

    public RecognizeOptionsInternal setSpeechOptions(SpeechOptionsInternal speechOptions) {
        this.speechOptions = speechOptions;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("targetParticipant", (JsonSerializable)this.targetParticipant);
        jsonWriter.writeBooleanField("interruptPrompt", this.interruptPrompt);
        jsonWriter.writeNumberField("initialSilenceTimeoutInSeconds", (Number)this.initialSilenceTimeoutInSeconds);
        jsonWriter.writeStringField("speechLanguage", this.speechLanguage);
        jsonWriter.writeStringField("speechRecognitionModelEndpointId", this.speechRecognitionModelEndpointId);
        jsonWriter.writeJsonField("dtmfOptions", (JsonSerializable)this.dtmfOptions);
        jsonWriter.writeArrayField("choices", this.choices, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("speechOptions", (JsonSerializable)this.speechOptions);
        return jsonWriter.writeEndObject();
    }

    public static RecognizeOptionsInternal fromJson(JsonReader jsonReader) throws IOException {
        return (RecognizeOptionsInternal)jsonReader.readObject(reader -> {
            RecognizeOptionsInternal deserializedRecognizeOptionsInternal = new RecognizeOptionsInternal();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("targetParticipant".equals(fieldName)) {
                    deserializedRecognizeOptionsInternal.targetParticipant = CommunicationIdentifierModel.fromJson(reader);
                    continue;
                }
                if ("interruptPrompt".equals(fieldName)) {
                    deserializedRecognizeOptionsInternal.interruptPrompt = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("initialSilenceTimeoutInSeconds".equals(fieldName)) {
                    deserializedRecognizeOptionsInternal.initialSilenceTimeoutInSeconds = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("speechLanguage".equals(fieldName)) {
                    deserializedRecognizeOptionsInternal.speechLanguage = reader.getString();
                    continue;
                }
                if ("speechRecognitionModelEndpointId".equals(fieldName)) {
                    deserializedRecognizeOptionsInternal.speechRecognitionModelEndpointId = reader.getString();
                    continue;
                }
                if ("dtmfOptions".equals(fieldName)) {
                    deserializedRecognizeOptionsInternal.dtmfOptions = DtmfOptionsInternal.fromJson(reader);
                    continue;
                }
                if ("choices".equals(fieldName)) {
                    List choices;
                    deserializedRecognizeOptionsInternal.choices = choices = reader.readArray(reader1 -> RecognitionChoiceInternal.fromJson(reader1));
                    continue;
                }
                if ("speechOptions".equals(fieldName)) {
                    deserializedRecognizeOptionsInternal.speechOptions = SpeechOptionsInternal.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRecognizeOptionsInternal;
        });
    }
}

