/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.callautomation.implementation.models;

import com.azure.communication.callautomation.implementation.models.CommunicationIdentifierModel;
import com.azure.communication.callautomation.implementation.models.PlayOptionsInternal;
import com.azure.communication.callautomation.implementation.models.PlaySourceInternal;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class PlayRequest
implements JsonSerializable<PlayRequest> {
    private List<PlaySourceInternal> playSources;
    private List<CommunicationIdentifierModel> playTo;
    private Boolean interruptCallMediaOperation;
    private PlayOptionsInternal playOptions;
    private String operationContext;
    private String operationCallbackUri;

    public List<PlaySourceInternal> getPlaySources() {
        return this.playSources;
    }

    public PlayRequest setPlaySources(List<PlaySourceInternal> playSources) {
        this.playSources = playSources;
        return this;
    }

    public List<CommunicationIdentifierModel> getPlayTo() {
        return this.playTo;
    }

    public PlayRequest setPlayTo(List<CommunicationIdentifierModel> playTo) {
        this.playTo = playTo;
        return this;
    }

    public Boolean isInterruptCallMediaOperation() {
        return this.interruptCallMediaOperation;
    }

    public PlayRequest setInterruptCallMediaOperation(Boolean interruptCallMediaOperation) {
        this.interruptCallMediaOperation = interruptCallMediaOperation;
        return this;
    }

    public PlayOptionsInternal getPlayOptions() {
        return this.playOptions;
    }

    public PlayRequest setPlayOptions(PlayOptionsInternal playOptions) {
        this.playOptions = playOptions;
        return this;
    }

    public String getOperationContext() {
        return this.operationContext;
    }

    public PlayRequest setOperationContext(String operationContext) {
        this.operationContext = operationContext;
        return this;
    }

    public String getOperationCallbackUri() {
        return this.operationCallbackUri;
    }

    public PlayRequest setOperationCallbackUri(String operationCallbackUri) {
        this.operationCallbackUri = operationCallbackUri;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("playSources", this.playSources, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("playTo", this.playTo, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeBooleanField("interruptCallMediaOperation", this.interruptCallMediaOperation);
        jsonWriter.writeJsonField("playOptions", (JsonSerializable)this.playOptions);
        jsonWriter.writeStringField("operationContext", this.operationContext);
        jsonWriter.writeStringField("operationCallbackUri", this.operationCallbackUri);
        return jsonWriter.writeEndObject();
    }

    public static PlayRequest fromJson(JsonReader jsonReader) throws IOException {
        return (PlayRequest)jsonReader.readObject(reader -> {
            PlayRequest deserializedPlayRequest = new PlayRequest();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("playSources".equals(fieldName)) {
                    List playSources;
                    deserializedPlayRequest.playSources = playSources = reader.readArray(reader1 -> PlaySourceInternal.fromJson(reader1));
                    continue;
                }
                if ("playTo".equals(fieldName)) {
                    List playTo;
                    deserializedPlayRequest.playTo = playTo = reader.readArray(reader1 -> CommunicationIdentifierModel.fromJson(reader1));
                    continue;
                }
                if ("interruptCallMediaOperation".equals(fieldName)) {
                    deserializedPlayRequest.interruptCallMediaOperation = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("playOptions".equals(fieldName)) {
                    deserializedPlayRequest.playOptions = PlayOptionsInternal.fromJson(reader);
                    continue;
                }
                if ("operationContext".equals(fieldName)) {
                    deserializedPlayRequest.operationContext = reader.getString();
                    continue;
                }
                if ("operationCallbackUri".equals(fieldName)) {
                    deserializedPlayRequest.operationCallbackUri = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedPlayRequest;
        });
    }
}

