/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.callautomation.implementation.models;

import com.azure.communication.callautomation.implementation.models.MediaStreamingAudioChannelTypeInternal;
import com.azure.communication.callautomation.implementation.models.StreamingTransportTypeInternal;
import com.azure.communication.callautomation.implementation.models.WebSocketMediaStreamingOptionsInternal;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public class MediaStreamingOptionsInternal
implements JsonSerializable<MediaStreamingOptionsInternal> {
    private StreamingTransportTypeInternal transportType = StreamingTransportTypeInternal.fromString("MediaStreamingOptionsInternal");
    private MediaStreamingAudioChannelTypeInternal audioChannelType;

    public StreamingTransportTypeInternal getTransportType() {
        return this.transportType;
    }

    public MediaStreamingAudioChannelTypeInternal getAudioChannelType() {
        return this.audioChannelType;
    }

    public MediaStreamingOptionsInternal setAudioChannelType(MediaStreamingAudioChannelTypeInternal audioChannelType) {
        this.audioChannelType = audioChannelType;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("audioChannelType", this.audioChannelType == null ? null : this.audioChannelType.toString());
        jsonWriter.writeStringField("transportType", this.transportType == null ? null : this.transportType.toString());
        return jsonWriter.writeEndObject();
    }

    public static MediaStreamingOptionsInternal fromJson(JsonReader jsonReader) throws IOException {
        return (MediaStreamingOptionsInternal)jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject();){
                MediaStreamingOptionsInternal mediaStreamingOptionsInternal;
                readerToUse.nextToken();
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("transportType".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    }
                    readerToUse.skipChildren();
                }
                if ("websocket".equals(discriminatorValue)) {
                    mediaStreamingOptionsInternal = WebSocketMediaStreamingOptionsInternal.fromJson(readerToUse.reset());
                    return mediaStreamingOptionsInternal;
                }
                mediaStreamingOptionsInternal = MediaStreamingOptionsInternal.fromJsonKnownDiscriminator(readerToUse.reset());
                return mediaStreamingOptionsInternal;
            }
        });
    }

    static MediaStreamingOptionsInternal fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return (MediaStreamingOptionsInternal)jsonReader.readObject(reader -> {
            MediaStreamingOptionsInternal deserializedMediaStreamingOptionsInternal = new MediaStreamingOptionsInternal();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("audioChannelType".equals(fieldName)) {
                    deserializedMediaStreamingOptionsInternal.audioChannelType = MediaStreamingAudioChannelTypeInternal.fromString(reader.getString());
                    continue;
                }
                if ("transportType".equals(fieldName)) {
                    deserializedMediaStreamingOptionsInternal.transportType = StreamingTransportTypeInternal.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMediaStreamingOptionsInternal;
        });
    }
}

