/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.callautomation.implementation.models;

import com.azure.communication.callautomation.implementation.models.CallConnectionStateModelInternal;
import com.azure.communication.callautomation.implementation.models.CommunicationIdentifierModel;
import com.azure.communication.callautomation.implementation.models.CommunicationUserIdentifierModel;
import com.azure.communication.callautomation.implementation.models.MediaStreamingSubscriptionInternal;
import com.azure.communication.callautomation.implementation.models.PhoneNumberIdentifierModel;
import com.azure.communication.callautomation.implementation.models.TranscriptionSubscriptionInternal;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class CallConnectionPropertiesInternal
implements JsonSerializable<CallConnectionPropertiesInternal> {
    private String callConnectionId;
    private String serverCallId;
    private List<CommunicationIdentifierModel> targets;
    private CallConnectionStateModelInternal callConnectionState;
    private String callbackUri;
    private PhoneNumberIdentifierModel sourceCallerIdNumber;
    private String sourceDisplayName;
    private CommunicationIdentifierModel source;
    private String correlationId;
    private CommunicationUserIdentifierModel answeredBy;
    private MediaStreamingSubscriptionInternal mediaStreamingSubscription;
    private TranscriptionSubscriptionInternal transcriptionSubscription;
    private PhoneNumberIdentifierModel answeredFor;

    public String getCallConnectionId() {
        return this.callConnectionId;
    }

    public CallConnectionPropertiesInternal setCallConnectionId(String callConnectionId) {
        this.callConnectionId = callConnectionId;
        return this;
    }

    public String getServerCallId() {
        return this.serverCallId;
    }

    public CallConnectionPropertiesInternal setServerCallId(String serverCallId) {
        this.serverCallId = serverCallId;
        return this;
    }

    public List<CommunicationIdentifierModel> getTargets() {
        return this.targets;
    }

    public CallConnectionPropertiesInternal setTargets(List<CommunicationIdentifierModel> targets) {
        this.targets = targets;
        return this;
    }

    public CallConnectionStateModelInternal getCallConnectionState() {
        return this.callConnectionState;
    }

    public CallConnectionPropertiesInternal setCallConnectionState(CallConnectionStateModelInternal callConnectionState) {
        this.callConnectionState = callConnectionState;
        return this;
    }

    public String getCallbackUri() {
        return this.callbackUri;
    }

    public CallConnectionPropertiesInternal setCallbackUri(String callbackUri) {
        this.callbackUri = callbackUri;
        return this;
    }

    public PhoneNumberIdentifierModel getSourceCallerIdNumber() {
        return this.sourceCallerIdNumber;
    }

    public CallConnectionPropertiesInternal setSourceCallerIdNumber(PhoneNumberIdentifierModel sourceCallerIdNumber) {
        this.sourceCallerIdNumber = sourceCallerIdNumber;
        return this;
    }

    public String getSourceDisplayName() {
        return this.sourceDisplayName;
    }

    public CallConnectionPropertiesInternal setSourceDisplayName(String sourceDisplayName) {
        this.sourceDisplayName = sourceDisplayName;
        return this;
    }

    public CommunicationIdentifierModel getSource() {
        return this.source;
    }

    public CallConnectionPropertiesInternal setSource(CommunicationIdentifierModel source) {
        this.source = source;
        return this;
    }

    public String getCorrelationId() {
        return this.correlationId;
    }

    public CallConnectionPropertiesInternal setCorrelationId(String correlationId) {
        this.correlationId = correlationId;
        return this;
    }

    public CommunicationUserIdentifierModel getAnsweredBy() {
        return this.answeredBy;
    }

    public CallConnectionPropertiesInternal setAnsweredBy(CommunicationUserIdentifierModel answeredBy) {
        this.answeredBy = answeredBy;
        return this;
    }

    public MediaStreamingSubscriptionInternal getMediaStreamingSubscription() {
        return this.mediaStreamingSubscription;
    }

    public CallConnectionPropertiesInternal setMediaStreamingSubscription(MediaStreamingSubscriptionInternal mediaStreamingSubscription) {
        this.mediaStreamingSubscription = mediaStreamingSubscription;
        return this;
    }

    public TranscriptionSubscriptionInternal getTranscriptionSubscription() {
        return this.transcriptionSubscription;
    }

    public CallConnectionPropertiesInternal setTranscriptionSubscription(TranscriptionSubscriptionInternal transcriptionSubscription) {
        this.transcriptionSubscription = transcriptionSubscription;
        return this;
    }

    public PhoneNumberIdentifierModel getAnsweredFor() {
        return this.answeredFor;
    }

    public CallConnectionPropertiesInternal setAnsweredFor(PhoneNumberIdentifierModel answeredFor) {
        this.answeredFor = answeredFor;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("callConnectionId", this.callConnectionId);
        jsonWriter.writeStringField("serverCallId", this.serverCallId);
        jsonWriter.writeArrayField("targets", this.targets, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("callConnectionState", this.callConnectionState == null ? null : this.callConnectionState.toString());
        jsonWriter.writeStringField("callbackUri", this.callbackUri);
        jsonWriter.writeJsonField("sourceCallerIdNumber", (JsonSerializable)this.sourceCallerIdNumber);
        jsonWriter.writeStringField("sourceDisplayName", this.sourceDisplayName);
        jsonWriter.writeJsonField("source", (JsonSerializable)this.source);
        jsonWriter.writeStringField("correlationId", this.correlationId);
        jsonWriter.writeJsonField("answeredBy", (JsonSerializable)this.answeredBy);
        jsonWriter.writeJsonField("mediaStreamingSubscription", (JsonSerializable)this.mediaStreamingSubscription);
        jsonWriter.writeJsonField("transcriptionSubscription", (JsonSerializable)this.transcriptionSubscription);
        jsonWriter.writeJsonField("answeredFor", (JsonSerializable)this.answeredFor);
        return jsonWriter.writeEndObject();
    }

    public static CallConnectionPropertiesInternal fromJson(JsonReader jsonReader) throws IOException {
        return (CallConnectionPropertiesInternal)jsonReader.readObject(reader -> {
            CallConnectionPropertiesInternal deserializedCallConnectionPropertiesInternal = new CallConnectionPropertiesInternal();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("callConnectionId".equals(fieldName)) {
                    deserializedCallConnectionPropertiesInternal.callConnectionId = reader.getString();
                    continue;
                }
                if ("serverCallId".equals(fieldName)) {
                    deserializedCallConnectionPropertiesInternal.serverCallId = reader.getString();
                    continue;
                }
                if ("targets".equals(fieldName)) {
                    List targets;
                    deserializedCallConnectionPropertiesInternal.targets = targets = reader.readArray(reader1 -> CommunicationIdentifierModel.fromJson(reader1));
                    continue;
                }
                if ("callConnectionState".equals(fieldName)) {
                    deserializedCallConnectionPropertiesInternal.callConnectionState = CallConnectionStateModelInternal.fromString(reader.getString());
                    continue;
                }
                if ("callbackUri".equals(fieldName)) {
                    deserializedCallConnectionPropertiesInternal.callbackUri = reader.getString();
                    continue;
                }
                if ("sourceCallerIdNumber".equals(fieldName)) {
                    deserializedCallConnectionPropertiesInternal.sourceCallerIdNumber = PhoneNumberIdentifierModel.fromJson(reader);
                    continue;
                }
                if ("sourceDisplayName".equals(fieldName)) {
                    deserializedCallConnectionPropertiesInternal.sourceDisplayName = reader.getString();
                    continue;
                }
                if ("source".equals(fieldName)) {
                    deserializedCallConnectionPropertiesInternal.source = CommunicationIdentifierModel.fromJson(reader);
                    continue;
                }
                if ("correlationId".equals(fieldName)) {
                    deserializedCallConnectionPropertiesInternal.correlationId = reader.getString();
                    continue;
                }
                if ("answeredBy".equals(fieldName)) {
                    deserializedCallConnectionPropertiesInternal.answeredBy = CommunicationUserIdentifierModel.fromJson(reader);
                    continue;
                }
                if ("mediaStreamingSubscription".equals(fieldName)) {
                    deserializedCallConnectionPropertiesInternal.mediaStreamingSubscription = MediaStreamingSubscriptionInternal.fromJson(reader);
                    continue;
                }
                if ("transcriptionSubscription".equals(fieldName)) {
                    deserializedCallConnectionPropertiesInternal.transcriptionSubscription = TranscriptionSubscriptionInternal.fromJson(reader);
                    continue;
                }
                if ("answeredFor".equals(fieldName)) {
                    deserializedCallConnectionPropertiesInternal.answeredFor = PhoneNumberIdentifierModel.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCallConnectionPropertiesInternal;
        });
    }
}

