/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.callautomation.implementation.eventprocessor;

import com.azure.communication.callautomation.implementation.eventprocessor.EventAwaiter;
import com.azure.communication.callautomation.implementation.eventprocessor.EventWithBacklogId;
import com.azure.communication.callautomation.models.events.CallAutomationEventBase;
import java.util.function.Predicate;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Sinks;

public final class EventAwaiterSingleTime
extends EventAwaiter {
    private final Predicate<CallAutomationEventBase> predicate;
    private final Sinks.One<EventWithBacklogId> task;

    public EventAwaiterSingleTime(Predicate<CallAutomationEventBase> predicate) {
        this.predicate = predicate;
        this.task = Sinks.one();
    }

    @Override
    public void onEventsReceived(EventWithBacklogId event) {
        if (this.predicate.test(event.getEvent())) {
            this.task.tryEmitValue((Object)event);
        }
    }

    public Mono<EventWithBacklogId> getEventWithBacklogId() {
        return this.task.asMono();
    }
}

