/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.callautomation.implementation.converters;

import com.azure.communication.callautomation.models.WordData;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import java.io.IOException;
import java.util.List;

public final class TranscriptionDataConverter {
    private String text;
    private String format;
    private double confidence;
    private long offset;
    private long duration;
    private List<WordData> words;
    private String participantRawID;
    private String resultStatus;

    public String getText() {
        return this.text;
    }

    public String getFormat() {
        return this.format;
    }

    public double getConfidence() {
        return this.confidence;
    }

    public long getDuration() {
        return this.duration;
    }

    public long getOffset() {
        return this.offset;
    }

    public List<WordData> getWords() {
        return this.words;
    }

    public String getParticipantRawID() {
        return this.participantRawID;
    }

    public String getResultStatus() {
        return this.resultStatus;
    }

    public static TranscriptionDataConverter fromJson(JsonReader jsonReader) throws IOException {
        return (TranscriptionDataConverter)jsonReader.readObject(reader -> {
            TranscriptionDataConverter converter = new TranscriptionDataConverter();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("text".equals(fieldName)) {
                    converter.text = reader.getString();
                    continue;
                }
                if ("format".equals(fieldName)) {
                    converter.format = reader.getString();
                    continue;
                }
                if ("confidence".equals(fieldName)) {
                    converter.confidence = reader.getDouble();
                    continue;
                }
                if ("offset".equals(fieldName)) {
                    converter.offset = reader.getLong();
                    continue;
                }
                if ("duration".equals(fieldName)) {
                    converter.duration = reader.getLong();
                    continue;
                }
                if ("words".equals(fieldName)) {
                    converter.words = reader.readArray(WordData::fromJson);
                    continue;
                }
                if ("participantRawID".equals(fieldName)) {
                    converter.participantRawID = reader.getString();
                    continue;
                }
                if ("resultStatus".equals(fieldName)) {
                    converter.resultStatus = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return converter;
        });
    }
}

