/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.callautomation;

import com.azure.communication.callautomation.CallConnectionAsync;
import com.azure.communication.callautomation.CallMedia;
import com.azure.communication.callautomation.models.AddParticipantOptions;
import com.azure.communication.callautomation.models.AddParticipantResult;
import com.azure.communication.callautomation.models.CallConnectionProperties;
import com.azure.communication.callautomation.models.CallInvite;
import com.azure.communication.callautomation.models.CallParticipant;
import com.azure.communication.callautomation.models.CancelAddParticipantOperationOptions;
import com.azure.communication.callautomation.models.CancelAddParticipantOperationResult;
import com.azure.communication.callautomation.models.MuteParticipantOptions;
import com.azure.communication.callautomation.models.MuteParticipantResult;
import com.azure.communication.callautomation.models.RemoveParticipantOptions;
import com.azure.communication.callautomation.models.RemoveParticipantResult;
import com.azure.communication.callautomation.models.TransferCallResult;
import com.azure.communication.callautomation.models.TransferCallToParticipantOptions;
import com.azure.communication.common.CommunicationIdentifier;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;

public final class CallConnection {
    private final CallConnectionAsync callConnectionAsync;

    CallConnection(CallConnectionAsync callConnectionAsync) {
        this.callConnectionAsync = callConnectionAsync;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public CallConnectionProperties getCallProperties() {
        return (CallConnectionProperties)this.callConnectionAsync.getCallProperties().block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<CallConnectionProperties> getCallPropertiesWithResponse(Context context) {
        return (Response)this.callConnectionAsync.getCallPropertiesWithResponseInternal(context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void hangUp(boolean isForEveryone) {
        this.callConnectionAsync.hangUp(isForEveryone).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> hangUpWithResponse(boolean isForEveryone, Context context) {
        return (Response)this.callConnectionAsync.hangUpWithResponseInternal(isForEveryone, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public CallParticipant getParticipant(CommunicationIdentifier targetParticipant) {
        return (CallParticipant)this.callConnectionAsync.getParticipant(targetParticipant).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<CallParticipant> getParticipantWithResponse(CommunicationIdentifier targetParticipant, Context context) {
        return (Response)this.callConnectionAsync.getParticipantWithResponseInternal(targetParticipant, context).block();
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<CallParticipant> listParticipants() {
        return new PagedIterable(this.callConnectionAsync.listParticipants());
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<CallParticipant> listParticipants(Context context) {
        return new PagedIterable(this.callConnectionAsync.listParticipantsWithContext(context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public TransferCallResult transferCallToParticipant(CommunicationIdentifier targetParticipant) {
        return (TransferCallResult)this.callConnectionAsync.transferCallToParticipant(targetParticipant).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<TransferCallResult> transferCallToParticipantWithResponse(TransferCallToParticipantOptions transferCallToParticipantOptions, Context context) {
        return (Response)this.callConnectionAsync.transferCallToParticipantWithResponseInternal(transferCallToParticipantOptions, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public AddParticipantResult addParticipant(CallInvite participant) {
        return (AddParticipantResult)this.callConnectionAsync.addParticipant(participant).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<AddParticipantResult> addParticipantWithResponse(AddParticipantOptions addParticipantOptions, Context context) {
        return (Response)this.callConnectionAsync.addParticipantWithResponseInternal(addParticipantOptions, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public RemoveParticipantResult removeParticipant(CommunicationIdentifier participantToRemove) {
        return (RemoveParticipantResult)this.callConnectionAsync.removeParticipant(participantToRemove).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<RemoveParticipantResult> removeParticipantWithResponse(RemoveParticipantOptions removeParticipantOptions, Context context) {
        return (Response)this.callConnectionAsync.removeParticipantWithResponseInternal(removeParticipantOptions, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public MuteParticipantResult muteParticipant(CommunicationIdentifier targetParticipant) {
        return (MuteParticipantResult)this.callConnectionAsync.muteParticipant(targetParticipant).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<MuteParticipantResult> muteParticipantWithResponse(MuteParticipantOptions options, Context context) {
        return (Response)this.callConnectionAsync.muteParticipantWithResponseInternal(options, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public CancelAddParticipantOperationResult cancelAddParticipantOperation(String invitationId) {
        return (CancelAddParticipantOperationResult)this.callConnectionAsync.cancelAddParticipantOperation(invitationId).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<CancelAddParticipantOperationResult> cancelAddParticipantOperationWithResponse(CancelAddParticipantOperationOptions cancelAddParticipantOperationOptions, Context context) {
        return (Response)this.callConnectionAsync.cancelAddParticipantOperationWithResponseInternal(cancelAddParticipantOperationOptions, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public CallMedia getCallMedia() {
        return new CallMedia(this.callConnectionAsync.getCallMediaAsync());
    }
}

