// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.openai.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The authentication options for Azure OpenAI On Your Data when using an API key.
 */
@Immutable
public final class OnYourDataVectorSearchApiKeyAuthenticationOptions
    extends OnYourDataVectorSearchAuthenticationOptions {

    /*
     * The type of authentication to use.
     */
    @Generated
    private OnYourDataVectorSearchAuthenticationType type = OnYourDataVectorSearchAuthenticationType.API_KEY;

    /*
     * The API key to use for authentication.
     */
    @Generated
    private final String key;

    /**
     * Creates an instance of OnYourDataVectorSearchApiKeyAuthenticationOptions class.
     *
     * @param key the key value to set.
     */
    @Generated
    public OnYourDataVectorSearchApiKeyAuthenticationOptions(String key) {
        this.key = key;
    }

    /**
     * Get the type property: The type of authentication to use.
     *
     * @return the type value.
     */
    @Generated
    @Override
    public OnYourDataVectorSearchAuthenticationType getType() {
        return this.type;
    }

    /**
     * Get the key property: The API key to use for authentication.
     *
     * @return the key value.
     */
    @Generated
    public String getKey() {
        return this.key;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("key", this.key);
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of OnYourDataVectorSearchApiKeyAuthenticationOptions from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of OnYourDataVectorSearchApiKeyAuthenticationOptions if the JsonReader was pointing to an
     * instance of it, or null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the OnYourDataVectorSearchApiKeyAuthenticationOptions.
     */
    @Generated
    public static OnYourDataVectorSearchApiKeyAuthenticationOptions fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String key = null;
            OnYourDataVectorSearchAuthenticationType type = OnYourDataVectorSearchAuthenticationType.API_KEY;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("key".equals(fieldName)) {
                    key = reader.getString();
                } else if ("type".equals(fieldName)) {
                    type = OnYourDataVectorSearchAuthenticationType.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }
            OnYourDataVectorSearchApiKeyAuthenticationOptions deserializedOnYourDataVectorSearchApiKeyAuthenticationOptions
                = new OnYourDataVectorSearchApiKeyAuthenticationOptions(key);
            deserializedOnYourDataVectorSearchApiKeyAuthenticationOptions.type = type;
            return deserializedOnYourDataVectorSearchApiKeyAuthenticationOptions;
        });
    }
}
