// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.openai.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The name and arguments of a function that should be called, as generated by the model.
 */
@Immutable
public final class FunctionCall implements JsonSerializable<FunctionCall> {

    /*
     * The name of the function to call.
     */
    @Generated
    private final String name;

    /*
     * The arguments to call the function with, as generated by the model in JSON format.
     * Note that the model does not always generate valid JSON, and may hallucinate parameters
     * not defined by your function schema. Validate the arguments in your code before calling
     * your function.
     */
    @Generated
    private final String arguments;

    /**
     * Creates an instance of FunctionCall class.
     *
     * @param name the name value to set.
     * @param arguments the arguments value to set.
     */
    @Generated
    public FunctionCall(String name, String arguments) {
        this.name = name;
        this.arguments = arguments;
    }

    /**
     * Get the name property: The name of the function to call.
     *
     * @return the name value.
     */
    @Generated
    public String getName() {
        return this.name;
    }

    /**
     * Get the arguments property: The arguments to call the function with, as generated by the model in JSON format.
     * Note that the model does not always generate valid JSON, and may hallucinate parameters
     * not defined by your function schema. Validate the arguments in your code before calling
     * your function.
     *
     * @return the arguments value.
     */
    @Generated
    public String getArguments() {
        return this.arguments;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("arguments", this.arguments);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of FunctionCall from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of FunctionCall if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the FunctionCall.
     */
    @Generated
    public static FunctionCall fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String name = null;
            String arguments = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    name = reader.getString();
                } else if ("arguments".equals(fieldName)) {
                    arguments = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }
            return new FunctionCall(name, arguments);
        });
    }
}
