// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.openai.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * A span object that represents a detected object and its bounding box information.
 */
@Immutable
public final class AzureGroundingEnhancementLineSpan implements JsonSerializable<AzureGroundingEnhancementLineSpan> {

    /*
     * The text content of the span that represents the detected object.
     */
    @Generated
    private final String text;

    /*
     * The character offset within the text where the span begins. This offset is defined as the position of the first
     * character of the span, counting from the start of the text as Unicode codepoints.
     */
    @Generated
    private final int offset;

    /*
     * The length of the span in characters, measured in Unicode codepoints.
     */
    @Generated
    private final int length;

    /*
     * An array of objects representing points in the polygon that encloses the detected object.
     */
    @Generated
    private final List<AzureGroundingEnhancementCoordinatePoint> polygon;

    /**
     * Creates an instance of AzureGroundingEnhancementLineSpan class.
     *
     * @param text the text value to set.
     * @param offset the offset value to set.
     * @param length the length value to set.
     * @param polygon the polygon value to set.
     */
    @Generated
    private AzureGroundingEnhancementLineSpan(String text, int offset, int length,
        List<AzureGroundingEnhancementCoordinatePoint> polygon) {
        this.text = text;
        this.offset = offset;
        this.length = length;
        this.polygon = polygon;
    }

    /**
     * Get the text property: The text content of the span that represents the detected object.
     *
     * @return the text value.
     */
    @Generated
    public String getText() {
        return this.text;
    }

    /**
     * Get the offset property: The character offset within the text where the span begins. This offset is defined as
     * the position of the first
     * character of the span, counting from the start of the text as Unicode codepoints.
     *
     * @return the offset value.
     */
    @Generated
    public int getOffset() {
        return this.offset;
    }

    /**
     * Get the length property: The length of the span in characters, measured in Unicode codepoints.
     *
     * @return the length value.
     */
    @Generated
    public int getLength() {
        return this.length;
    }

    /**
     * Get the polygon property: An array of objects representing points in the polygon that encloses the detected
     * object.
     *
     * @return the polygon value.
     */
    @Generated
    public List<AzureGroundingEnhancementCoordinatePoint> getPolygon() {
        return this.polygon;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("text", this.text);
        jsonWriter.writeIntField("offset", this.offset);
        jsonWriter.writeIntField("length", this.length);
        jsonWriter.writeArrayField("polygon", this.polygon, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AzureGroundingEnhancementLineSpan from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of AzureGroundingEnhancementLineSpan if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the AzureGroundingEnhancementLineSpan.
     */
    @Generated
    public static AzureGroundingEnhancementLineSpan fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String text = null;
            int offset = 0;
            int length = 0;
            List<AzureGroundingEnhancementCoordinatePoint> polygon = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("text".equals(fieldName)) {
                    text = reader.getString();
                } else if ("offset".equals(fieldName)) {
                    offset = reader.getInt();
                } else if ("length".equals(fieldName)) {
                    length = reader.getInt();
                } else if ("polygon".equals(fieldName)) {
                    polygon = reader.readArray(reader1 -> AzureGroundingEnhancementCoordinatePoint.fromJson(reader1));
                } else {
                    reader.skipChildren();
                }
            }
            return new AzureGroundingEnhancementLineSpan(text, offset, length, polygon);
        });
    }
}
