// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.openai.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * A single instance of additional context information available when Azure OpenAI chat extensions are involved
 * in the generation of a corresponding chat completions response. This context information is only populated when
 * using an Azure OpenAI request configured to use a matching extension.
 */
@Immutable
public final class AzureChatExtensionDataSourceResponseCitation
    implements JsonSerializable<AzureChatExtensionDataSourceResponseCitation> {

    /*
     * The content of the citation.
     */
    @Generated
    private final String content;

    /*
     * The title of the citation.
     */
    @Generated
    private String title;

    /*
     * The URL of the citation.
     */
    @Generated
    private String url;

    /*
     * The file path of the citation.
     */
    @Generated
    private String filepath;

    /*
     * The chunk ID of the citation.
     */
    @Generated
    private String chunkId;

    /**
     * Creates an instance of AzureChatExtensionDataSourceResponseCitation class.
     *
     * @param content the content value to set.
     */
    @Generated
    private AzureChatExtensionDataSourceResponseCitation(String content) {
        this.content = content;
    }

    /**
     * Get the content property: The content of the citation.
     *
     * @return the content value.
     */
    @Generated
    public String getContent() {
        return this.content;
    }

    /**
     * Get the title property: The title of the citation.
     *
     * @return the title value.
     */
    @Generated
    public String getTitle() {
        return this.title;
    }

    /**
     * Get the url property: The URL of the citation.
     *
     * @return the url value.
     */
    @Generated
    public String getUrl() {
        return this.url;
    }

    /**
     * Get the filepath property: The file path of the citation.
     *
     * @return the filepath value.
     */
    @Generated
    public String getFilepath() {
        return this.filepath;
    }

    /**
     * Get the chunkId property: The chunk ID of the citation.
     *
     * @return the chunkId value.
     */
    @Generated
    public String getChunkId() {
        return this.chunkId;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("content", this.content);
        jsonWriter.writeStringField("title", this.title);
        jsonWriter.writeStringField("url", this.url);
        jsonWriter.writeStringField("filepath", this.filepath);
        jsonWriter.writeStringField("chunk_id", this.chunkId);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AzureChatExtensionDataSourceResponseCitation from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of AzureChatExtensionDataSourceResponseCitation if the JsonReader was pointing to an instance
     * of it, or null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the AzureChatExtensionDataSourceResponseCitation.
     */
    @Generated
    public static AzureChatExtensionDataSourceResponseCitation fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String content = null;
            String title = null;
            String url = null;
            String filepath = null;
            String chunkId = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("content".equals(fieldName)) {
                    content = reader.getString();
                } else if ("title".equals(fieldName)) {
                    title = reader.getString();
                } else if ("url".equals(fieldName)) {
                    url = reader.getString();
                } else if ("filepath".equals(fieldName)) {
                    filepath = reader.getString();
                } else if ("chunk_id".equals(fieldName)) {
                    chunkId = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }
            AzureChatExtensionDataSourceResponseCitation deserializedAzureChatExtensionDataSourceResponseCitation
                = new AzureChatExtensionDataSourceResponseCitation(content);
            deserializedAzureChatExtensionDataSourceResponseCitation.title = title;
            deserializedAzureChatExtensionDataSourceResponseCitation.url = url;
            deserializedAzureChatExtensionDataSourceResponseCitation.filepath = filepath;
            deserializedAzureChatExtensionDataSourceResponseCitation.chunkId = chunkId;
            return deserializedAzureChatExtensionDataSourceResponseCitation;
        });
    }
}
