/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.models;

import com.azure.ai.openai.models.ImageGenerationQuality;
import com.azure.ai.openai.models.ImageGenerationResponseFormat;
import com.azure.ai.openai.models.ImageGenerationStyle;
import com.azure.ai.openai.models.ImageSize;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class ImageGenerationOptions
implements JsonSerializable<ImageGenerationOptions> {
    private final String prompt;
    private Integer n;
    private ImageSize size;
    private String user;
    private ImageGenerationResponseFormat responseFormat;
    private String model;
    private ImageGenerationQuality quality;
    private ImageGenerationStyle style;

    public ImageGenerationOptions(String prompt) {
        this.prompt = prompt;
    }

    public String getPrompt() {
        return this.prompt;
    }

    public Integer getN() {
        return this.n;
    }

    public ImageGenerationOptions setN(Integer n) {
        this.n = n;
        return this;
    }

    public ImageSize getSize() {
        return this.size;
    }

    public ImageGenerationOptions setSize(ImageSize size) {
        this.size = size;
        return this;
    }

    public String getUser() {
        return this.user;
    }

    public ImageGenerationOptions setUser(String user) {
        this.user = user;
        return this;
    }

    public ImageGenerationResponseFormat getResponseFormat() {
        return this.responseFormat;
    }

    public ImageGenerationOptions setResponseFormat(ImageGenerationResponseFormat responseFormat) {
        this.responseFormat = responseFormat;
        return this;
    }

    public String getModel() {
        return this.model;
    }

    public ImageGenerationOptions setModel(String model) {
        this.model = model;
        return this;
    }

    public ImageGenerationQuality getQuality() {
        return this.quality;
    }

    public ImageGenerationOptions setQuality(ImageGenerationQuality quality) {
        this.quality = quality;
        return this;
    }

    public ImageGenerationStyle getStyle() {
        return this.style;
    }

    public ImageGenerationOptions setStyle(ImageGenerationStyle style) {
        this.style = style;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("prompt", this.prompt);
        jsonWriter.writeStringField("model", this.model);
        jsonWriter.writeNumberField("n", (Number)this.n);
        jsonWriter.writeStringField("size", this.size == null ? null : this.size.toString());
        jsonWriter.writeStringField("response_format", this.responseFormat == null ? null : this.responseFormat.toString());
        jsonWriter.writeStringField("quality", this.quality == null ? null : this.quality.toString());
        jsonWriter.writeStringField("style", this.style == null ? null : this.style.toString());
        jsonWriter.writeStringField("user", this.user);
        return jsonWriter.writeEndObject();
    }

    public static ImageGenerationOptions fromJson(JsonReader jsonReader) throws IOException {
        return (ImageGenerationOptions)jsonReader.readObject(reader -> {
            String prompt = null;
            String model = null;
            Integer n = null;
            ImageSize size = null;
            ImageGenerationResponseFormat responseFormat = null;
            ImageGenerationQuality quality = null;
            ImageGenerationStyle style = null;
            String user = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("prompt".equals(fieldName)) {
                    prompt = reader.getString();
                    continue;
                }
                if ("model".equals(fieldName)) {
                    model = reader.getString();
                    continue;
                }
                if ("n".equals(fieldName)) {
                    n = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("size".equals(fieldName)) {
                    size = ImageSize.fromString(reader.getString());
                    continue;
                }
                if ("response_format".equals(fieldName)) {
                    responseFormat = ImageGenerationResponseFormat.fromString(reader.getString());
                    continue;
                }
                if ("quality".equals(fieldName)) {
                    quality = ImageGenerationQuality.fromString(reader.getString());
                    continue;
                }
                if ("style".equals(fieldName)) {
                    style = ImageGenerationStyle.fromString(reader.getString());
                    continue;
                }
                if ("user".equals(fieldName)) {
                    user = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            ImageGenerationOptions deserializedImageGenerationOptions = new ImageGenerationOptions(prompt);
            deserializedImageGenerationOptions.model = model;
            deserializedImageGenerationOptions.n = n;
            deserializedImageGenerationOptions.size = size;
            deserializedImageGenerationOptions.responseFormat = responseFormat;
            deserializedImageGenerationOptions.quality = quality;
            deserializedImageGenerationOptions.style = style;
            deserializedImageGenerationOptions.user = user;
            return deserializedImageGenerationOptions;
        });
    }
}

