/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.models;

import com.azure.ai.openai.models.ChatRequestMessage;
import com.azure.ai.openai.models.ChatRole;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class ChatRequestSystemMessage
extends ChatRequestMessage {
    private final String content;
    private String name;
    private ChatRole role = ChatRole.SYSTEM;

    public ChatRequestSystemMessage(String content) {
        this.content = content;
    }

    public String getContent() {
        return this.content;
    }

    public String getName() {
        return this.name;
    }

    public ChatRequestSystemMessage setName(String name) {
        this.name = name;
        return this;
    }

    @Override
    public ChatRole getRole() {
        return this.role;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("content", this.content);
        jsonWriter.writeStringField("role", this.role == null ? null : this.role.toString());
        jsonWriter.writeStringField("name", this.name);
        return jsonWriter.writeEndObject();
    }

    public static ChatRequestSystemMessage fromJson(JsonReader jsonReader) throws IOException {
        return (ChatRequestSystemMessage)jsonReader.readObject(reader -> {
            String content = null;
            ChatRole role = ChatRole.SYSTEM;
            String name = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("content".equals(fieldName)) {
                    content = reader.getString();
                    continue;
                }
                if ("role".equals(fieldName)) {
                    role = ChatRole.fromString(reader.getString());
                    continue;
                }
                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            ChatRequestSystemMessage deserializedChatRequestSystemMessage = new ChatRequestSystemMessage(content);
            deserializedChatRequestSystemMessage.role = role;
            deserializedChatRequestSystemMessage.name = name;
            return deserializedChatRequestSystemMessage;
        });
    }
}

