// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.openai.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The authentication options for Azure OpenAI On Your Data when using access token.
 */
@Immutable
public final class OnYourDataAccessTokenAuthenticationOptions extends OnYourDataAuthenticationOptions {

    /*
     * The access token to use for authentication.
     */
    @Generated
    private final String accessToken;

    /**
     * Creates an instance of OnYourDataAccessTokenAuthenticationOptions class.
     *
     * @param accessToken the accessToken value to set.
     */
    @Generated
    public OnYourDataAccessTokenAuthenticationOptions(String accessToken) {
        this.accessToken = accessToken;
    }

    /**
     * Get the accessToken property: The access token to use for authentication.
     *
     * @return the accessToken value.
     */
    @Generated
    public String getAccessToken() {
        return this.accessToken;
    }

    /*
     * The authentication type.
     */
    @Generated
    private OnYourDataAuthenticationType type = OnYourDataAuthenticationType.ACCESS_TOKEN;

    /**
     * Get the type property: The authentication type.
     *
     * @return the type value.
     */
    @Generated
    @Override
    public OnYourDataAuthenticationType getType() {
        return this.type;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("access_token", this.accessToken);
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of OnYourDataAccessTokenAuthenticationOptions from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of OnYourDataAccessTokenAuthenticationOptions if the JsonReader was pointing to an instance
     * of it, or null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the OnYourDataAccessTokenAuthenticationOptions.
     */
    @Generated
    public static OnYourDataAccessTokenAuthenticationOptions fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String accessToken = null;
            OnYourDataAuthenticationType type = OnYourDataAuthenticationType.ACCESS_TOKEN;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("access_token".equals(fieldName)) {
                    accessToken = reader.getString();
                } else if ("type".equals(fieldName)) {
                    type = OnYourDataAuthenticationType.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }
            OnYourDataAccessTokenAuthenticationOptions deserializedOnYourDataAccessTokenAuthenticationOptions
                = new OnYourDataAccessTokenAuthenticationOptions(accessToken);
            deserializedOnYourDataAccessTokenAuthenticationOptions.type = type;
            return deserializedOnYourDataAccessTokenAuthenticationOptions;
        });
    }
}
