// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.openai.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * A representation of a single generated image, provided as either base64-encoded data or as a URL from which the image
 * may be retrieved.
 */
@Immutable
public final class ImageGenerationData implements JsonSerializable<ImageGenerationData> {

    /*
     * The URL that provides temporary access to download the generated image.
     */
    @Generated
    private String url;

    /*
     * The complete data for an image, represented as a base64-encoded string.
     */
    @Generated
    private String base64Data;

    /*
     * The final prompt used by the model to generate the image.
     * Only provided with dall-3-models and only when revisions were made to the prompt.
     */
    @Generated
    private String revisedPrompt;

    /**
     * Creates an instance of ImageGenerationData class.
     */
    @Generated
    private ImageGenerationData() {
    }

    /**
     * Get the url property: The URL that provides temporary access to download the generated image.
     *
     * @return the url value.
     */
    @Generated
    public String getUrl() {
        return this.url;
    }

    /**
     * Get the base64Data property: The complete data for an image, represented as a base64-encoded string.
     *
     * @return the base64Data value.
     */
    @Generated
    public String getBase64Data() {
        return this.base64Data;
    }

    /**
     * Get the revisedPrompt property: The final prompt used by the model to generate the image.
     * Only provided with dall-3-models and only when revisions were made to the prompt.
     *
     * @return the revisedPrompt value.
     */
    @Generated
    public String getRevisedPrompt() {
        return this.revisedPrompt;
    }

    /*
     * Information about the content filtering results.
     */
    @Generated
    private ImageGenerationContentFilterResults contentFilterResults;

    /*
     * Information about the content filtering category (hate, sexual, violence, self_harm), if
     * it has been detected, as well as the severity level (very_low, low, medium, high-scale
     * that determines the intensity and risk level of harmful content) and if it has been
     * filtered or not. Information about jailbreak content and profanity, if it has been detected,
     * and if it has been filtered or not. And information about customer block list, if it has
     * been filtered and its id.
     */
    @Generated
    private ImageGenerationPromptFilterResults promptFilterResults;

    /**
     * Get the contentFilterResults property: Information about the content filtering results.
     *
     * @return the contentFilterResults value.
     */
    @Generated
    public ImageGenerationContentFilterResults getContentFilterResults() {
        return this.contentFilterResults;
    }

    /**
     * Get the promptFilterResults property: Information about the content filtering category (hate, sexual, violence,
     * self_harm), if
     * it has been detected, as well as the severity level (very_low, low, medium, high-scale
     * that determines the intensity and risk level of harmful content) and if it has been
     * filtered or not. Information about jailbreak content and profanity, if it has been detected,
     * and if it has been filtered or not. And information about customer block list, if it has
     * been filtered and its id.
     *
     * @return the promptFilterResults value.
     */
    @Generated
    public ImageGenerationPromptFilterResults getPromptFilterResults() {
        return this.promptFilterResults;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("url", this.url);
        jsonWriter.writeStringField("b64_json", this.base64Data);
        jsonWriter.writeJsonField("content_filter_results", this.contentFilterResults);
        jsonWriter.writeStringField("revised_prompt", this.revisedPrompt);
        jsonWriter.writeJsonField("prompt_filter_results", this.promptFilterResults);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ImageGenerationData from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of ImageGenerationData if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the ImageGenerationData.
     */
    @Generated
    public static ImageGenerationData fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ImageGenerationData deserializedImageGenerationData = new ImageGenerationData();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("url".equals(fieldName)) {
                    deserializedImageGenerationData.url = reader.getString();
                } else if ("b64_json".equals(fieldName)) {
                    deserializedImageGenerationData.base64Data = reader.getString();
                } else if ("content_filter_results".equals(fieldName)) {
                    deserializedImageGenerationData.contentFilterResults
                        = ImageGenerationContentFilterResults.fromJson(reader);
                } else if ("revised_prompt".equals(fieldName)) {
                    deserializedImageGenerationData.revisedPrompt = reader.getString();
                } else if ("prompt_filter_results".equals(fieldName)) {
                    deserializedImageGenerationData.promptFilterResults
                        = ImageGenerationPromptFilterResults.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }
            return deserializedImageGenerationData;
        });
    }
}
