// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.openai.models;

import com.azure.core.annotation.Generated;
import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * The type of Elasticsearch® retrieval query that should be executed when using it as an Azure OpenAI chat extension.
 */
public final class ElasticsearchQueryType extends ExpandableStringEnum<ElasticsearchQueryType> {

    /**
     * Represents the default, simple query parser.
     */
    @Generated
    public static final ElasticsearchQueryType SIMPLE = fromString("simple");

    /**
     * Represents vector search over computed data.
     */
    @Generated
    public static final ElasticsearchQueryType VECTOR = fromString("vector");

    /**
     * Creates a new instance of ElasticsearchQueryType value.
     *
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Generated
    @Deprecated
    public ElasticsearchQueryType() {
    }

    /**
     * Creates or finds a ElasticsearchQueryType from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding ElasticsearchQueryType.
     */
    @Generated
    public static ElasticsearchQueryType fromString(String name) {
        return fromString(name, ElasticsearchQueryType.class);
    }

    /**
     * Gets known ElasticsearchQueryType values.
     *
     * @return known ElasticsearchQueryType values.
     */
    @Generated
    public static Collection<ElasticsearchQueryType> values() {
        return values(ElasticsearchQueryType.class);
    }
}
