// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.openai.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Information about filtered content severity level and if it has been filtered or not.
 */
@Immutable
public final class ContentFilterResult implements JsonSerializable<ContentFilterResult> {

    /*
     * Ratings for the intensity and risk level of filtered content.
     */
    @Generated
    private final ContentFilterSeverity severity;

    /*
     * A value indicating whether or not the content has been filtered.
     */
    @Generated
    private final boolean filtered;

    /**
     * Get the severity property: Ratings for the intensity and risk level of filtered content.
     *
     * @return the severity value.
     */
    @Generated
    public ContentFilterSeverity getSeverity() {
        return this.severity;
    }

    /**
     * Get the filtered property: A value indicating whether or not the content has been filtered.
     *
     * @return the filtered value.
     */
    @Generated
    public boolean isFiltered() {
        return this.filtered;
    }

    /**
     * Creates an instance of ContentFilterResult class.
     *
     * @param filtered the filtered value to set.
     * @param severity the severity value to set.
     */
    @Generated
    private ContentFilterResult(boolean filtered, ContentFilterSeverity severity) {
        this.filtered = filtered;
        this.severity = severity;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("filtered", this.filtered);
        jsonWriter.writeStringField("severity", this.severity == null ? null : this.severity.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ContentFilterResult from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of ContentFilterResult if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ContentFilterResult.
     */
    @Generated
    public static ContentFilterResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            boolean filtered = false;
            ContentFilterSeverity severity = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("filtered".equals(fieldName)) {
                    filtered = reader.getBoolean();
                } else if ("severity".equals(fieldName)) {
                    severity = ContentFilterSeverity.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }
            return new ContentFilterResult(filtered, severity);
        });
    }
}
