// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.openai.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * A request chat message representing requested output from a configured tool.
 */
@Immutable
public final class ChatRequestToolMessage extends ChatRequestMessage {

    /*
     * The content of the message.
     */
    @Generated
    private final String content;

    /*
     * The ID of the tool call resolved by the provided content.
     */
    @Generated
    private final String toolCallId;

    /**
     * Creates an instance of ChatRequestToolMessage class.
     *
     * @param content the content value to set.
     * @param toolCallId the toolCallId value to set.
     */
    @Generated
    public ChatRequestToolMessage(String content, String toolCallId) {
        this.content = content;
        this.toolCallId = toolCallId;
    }

    /**
     * Get the content property: The content of the message.
     *
     * @return the content value.
     */
    @Generated
    public String getContent() {
        return this.content;
    }

    /**
     * Get the toolCallId property: The ID of the tool call resolved by the provided content.
     *
     * @return the toolCallId value.
     */
    @Generated
    public String getToolCallId() {
        return this.toolCallId;
    }

    /*
     * The chat role associated with this message.
     */
    @Generated
    private ChatRole role = ChatRole.TOOL;

    /**
     * Get the role property: The chat role associated with this message.
     *
     * @return the role value.
     */
    @Generated
    @Override
    public ChatRole getRole() {
        return this.role;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("content", this.content);
        jsonWriter.writeStringField("tool_call_id", this.toolCallId);
        jsonWriter.writeStringField("role", this.role == null ? null : this.role.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ChatRequestToolMessage from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of ChatRequestToolMessage if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ChatRequestToolMessage.
     */
    @Generated
    public static ChatRequestToolMessage fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String content = null;
            String toolCallId = null;
            ChatRole role = ChatRole.TOOL;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("content".equals(fieldName)) {
                    content = reader.getString();
                } else if ("tool_call_id".equals(fieldName)) {
                    toolCallId = reader.getString();
                } else if ("role".equals(fieldName)) {
                    role = ChatRole.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }
            ChatRequestToolMessage deserializedChatRequestToolMessage = new ChatRequestToolMessage(content, toolCallId);
            deserializedChatRequestToolMessage.role = role;
            return deserializedChatRequestToolMessage;
        });
    }
}
