// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.openai.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Map;

/**
 * Defines the request to create a batch.
 */
@Fluent
public final class BatchCreateRequest implements JsonSerializable<BatchCreateRequest> {

    /*
     * The API endpoint used by the batch.
     */
    @Generated
    private final String endpoint;

    /*
     * The ID of the input file for the batch.
     */
    @Generated
    private final String inputFileId;

    /*
     * The time frame within which the batch should be processed.
     */
    @Generated
    private final String completionWindow;

    /*
     * A set of key-value pairs that can be attached to the batch. This can be useful for storing additional information
     * about the batch in a structured format.
     */
    @Generated
    private Map<String, String> metadata;

    /**
     * Creates an instance of BatchCreateRequest class.
     *
     * @param endpoint the endpoint value to set.
     * @param inputFileId the inputFileId value to set.
     * @param completionWindow the completionWindow value to set.
     */
    @Generated
    public BatchCreateRequest(String endpoint, String inputFileId, String completionWindow) {
        this.endpoint = endpoint;
        this.inputFileId = inputFileId;
        this.completionWindow = completionWindow;
    }

    /**
     * Get the endpoint property: The API endpoint used by the batch.
     *
     * @return the endpoint value.
     */
    @Generated
    public String getEndpoint() {
        return this.endpoint;
    }

    /**
     * Get the inputFileId property: The ID of the input file for the batch.
     *
     * @return the inputFileId value.
     */
    @Generated
    public String getInputFileId() {
        return this.inputFileId;
    }

    /**
     * Get the completionWindow property: The time frame within which the batch should be processed.
     *
     * @return the completionWindow value.
     */
    @Generated
    public String getCompletionWindow() {
        return this.completionWindow;
    }

    /**
     * Get the metadata property: A set of key-value pairs that can be attached to the batch. This can be useful for
     * storing additional information about the batch in a structured format.
     *
     * @return the metadata value.
     */
    @Generated
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    /**
     * Set the metadata property: A set of key-value pairs that can be attached to the batch. This can be useful for
     * storing additional information about the batch in a structured format.
     *
     * @param metadata the metadata value to set.
     * @return the BatchCreateRequest object itself.
     */
    @Generated
    public BatchCreateRequest setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("endpoint", this.endpoint);
        jsonWriter.writeStringField("input_file_id", this.inputFileId);
        jsonWriter.writeStringField("completion_window", this.completionWindow);
        jsonWriter.writeMapField("metadata", this.metadata, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of BatchCreateRequest from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of BatchCreateRequest if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the BatchCreateRequest.
     */
    @Generated
    public static BatchCreateRequest fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String endpoint = null;
            String inputFileId = null;
            String completionWindow = null;
            Map<String, String> metadata = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("endpoint".equals(fieldName)) {
                    endpoint = reader.getString();
                } else if ("input_file_id".equals(fieldName)) {
                    inputFileId = reader.getString();
                } else if ("completion_window".equals(fieldName)) {
                    completionWindow = reader.getString();
                } else if ("metadata".equals(fieldName)) {
                    metadata = reader.readMap(reader1 -> reader1.getString());
                } else {
                    reader.skipChildren();
                }
            }
            BatchCreateRequest deserializedBatchCreateRequest
                = new BatchCreateRequest(endpoint, inputFileId, completionWindow);
            deserializedBatchCreateRequest.metadata = metadata;
            return deserializedBatchCreateRequest;
        });
    }
}
