// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.openai.models;

import com.azure.core.annotation.Generated;
import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * Defines the timestamp granularities that can be requested on a verbose transcription response.
 */
public final class AudioTranscriptionTimestampGranularity
    extends ExpandableStringEnum<AudioTranscriptionTimestampGranularity> {

    /**
     * Indicates that responses should include timing information about each transcribed word. Note that generating word
     * timestamp information will incur additional response latency.
     */
    @Generated
    public static final AudioTranscriptionTimestampGranularity WORD = fromString("word");

    /**
     * Indicates that responses should include timing and other information about each transcribed audio segment. Audio
     * segment timestamp information does not incur any additional latency.
     */
    @Generated
    public static final AudioTranscriptionTimestampGranularity SEGMENT = fromString("segment");

    /**
     * Creates a new instance of AudioTranscriptionTimestampGranularity value.
     *
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Generated
    @Deprecated
    public AudioTranscriptionTimestampGranularity() {
    }

    /**
     * Creates or finds a AudioTranscriptionTimestampGranularity from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding AudioTranscriptionTimestampGranularity.
     */
    @Generated
    public static AudioTranscriptionTimestampGranularity fromString(String name) {
        return fromString(name, AudioTranscriptionTimestampGranularity.class);
    }

    /**
     * Gets known AudioTranscriptionTimestampGranularity values.
     *
     * @return known AudioTranscriptionTimestampGranularity values.
     */
    @Generated
    public static Collection<AudioTranscriptionTimestampGranularity> values() {
        return values(AudioTranscriptionTimestampGranularity.class);
    }
}
