// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.openai.models;

import com.azure.core.annotation.Generated;
import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * Defines available options for the underlying response format of output transcription information.
 */
public final class AudioTranscriptionFormat extends ExpandableStringEnum<AudioTranscriptionFormat> {

    /**
     * Use a response body that is a JSON object containing a single 'text' field for the transcription.
     */
    @Generated
    public static final AudioTranscriptionFormat JSON = fromString("json");

    /**
     * Use a response body that is a JSON object containing transcription text along with timing, segments, and other
     * metadata.
     */
    @Generated
    public static final AudioTranscriptionFormat VERBOSE_JSON = fromString("verbose_json");

    /**
     * Use a response body that is plain text containing the raw, unannotated transcription.
     */
    @Generated
    public static final AudioTranscriptionFormat TEXT = fromString("text");

    /**
     * Use a response body that is plain text in SubRip (SRT) format that also includes timing information.
     */
    @Generated
    public static final AudioTranscriptionFormat SRT = fromString("srt");

    /**
     * Use a response body that is plain text in Web Video Text Tracks (VTT) format that also includes timing
     * information.
     */
    @Generated
    public static final AudioTranscriptionFormat VTT = fromString("vtt");

    /**
     * Creates a new instance of AudioTranscriptionFormat value.
     *
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Generated
    @Deprecated
    public AudioTranscriptionFormat() {
    }

    /**
     * Creates or finds a AudioTranscriptionFormat from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding AudioTranscriptionFormat.
     */
    @Generated
    public static AudioTranscriptionFormat fromString(String name) {
        return fromString(name, AudioTranscriptionFormat.class);
    }

    /**
     * Gets known AudioTranscriptionFormat values.
     *
     * @return known AudioTranscriptionFormat values.
     */
    @Generated
    public static Collection<AudioTranscriptionFormat> values() {
        return values(AudioTranscriptionFormat.class);
    }
}
