// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.openai.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.Duration;
import java.util.List;

/**
 * Result information for an operation that transcribed spoken audio into written text.
 */
@Immutable
public final class AudioTranscription implements JsonSerializable<AudioTranscription> {

    /*
     * The transcribed text for the provided audio data.
     */
    @Generated
    private final String text;

    /*
     * The label that describes which operation type generated the accompanying response data.
     */
    @Generated
    private AudioTaskLabel task;

    /*
     * The spoken language that was detected in the transcribed audio data.
     * This is expressed as a two-letter ISO-639-1 language code like 'en' or 'fr'.
     */
    @Generated
    private String language;

    /*
     * The total duration of the audio processed to produce accompanying transcription information.
     */
    @Generated
    private Double duration;

    /*
     * A collection of information about the timing, probabilities, and other detail of each processed audio segment.
     */
    @Generated
    private List<AudioTranscriptionSegment> segments;

    /**
     * Creates an instance of AudioTranscription class.
     *
     * @param text the text value to set.
     */
    @Generated
    private AudioTranscription(String text) {
        this.text = text;
    }

    /**
     * Get the text property: The transcribed text for the provided audio data.
     *
     * @return the text value.
     */
    @Generated
    public String getText() {
        return this.text;
    }

    /**
     * Get the task property: The label that describes which operation type generated the accompanying response data.
     *
     * @return the task value.
     */
    @Generated
    public AudioTaskLabel getTask() {
        return this.task;
    }

    /**
     * Get the language property: The spoken language that was detected in the transcribed audio data.
     * This is expressed as a two-letter ISO-639-1 language code like 'en' or 'fr'.
     *
     * @return the language value.
     */
    @Generated
    public String getLanguage() {
        return this.language;
    }

    /**
     * Get the duration property: The total duration of the audio processed to produce accompanying transcription
     * information.
     *
     * @return the duration value.
     */
    @Generated
    public Duration getDuration() {
        if (this.duration == null) {
            return null;
        }
        return Duration.ofNanos((long) (this.duration * 1000_000_000L));
    }

    /**
     * Get the segments property: A collection of information about the timing, probabilities, and other detail of each
     * processed audio segment.
     *
     * @return the segments value.
     */
    @Generated
    public List<AudioTranscriptionSegment> getSegments() {
        return this.segments;
    }

    /*
     * A collection of information about the timing of each processed word.
     */
    @Generated
    private List<AudioTranscriptionWord> words;

    /**
     * Get the words property: A collection of information about the timing of each processed word.
     *
     * @return the words value.
     */
    @Generated
    public List<AudioTranscriptionWord> getWords() {
        return this.words;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("text", this.text);
        jsonWriter.writeStringField("task", this.task == null ? null : this.task.toString());
        jsonWriter.writeStringField("language", this.language);
        jsonWriter.writeNumberField("duration", this.duration);
        jsonWriter.writeArrayField("segments", this.segments, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("words", this.words, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AudioTranscription from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of AudioTranscription if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the AudioTranscription.
     */
    @Generated
    public static AudioTranscription fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String text = null;
            AudioTaskLabel task = null;
            String language = null;
            Double duration = null;
            List<AudioTranscriptionSegment> segments = null;
            List<AudioTranscriptionWord> words = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("text".equals(fieldName)) {
                    text = reader.getString();
                } else if ("task".equals(fieldName)) {
                    task = AudioTaskLabel.fromString(reader.getString());
                } else if ("language".equals(fieldName)) {
                    language = reader.getString();
                } else if ("duration".equals(fieldName)) {
                    duration = reader.getNullable(JsonReader::getDouble);
                } else if ("segments".equals(fieldName)) {
                    segments = reader.readArray(reader1 -> AudioTranscriptionSegment.fromJson(reader1));
                } else if ("words".equals(fieldName)) {
                    words = reader.readArray(reader1 -> AudioTranscriptionWord.fromJson(reader1));
                } else {
                    reader.skipChildren();
                }
            }
            AudioTranscription deserializedAudioTranscription = new AudioTranscription(text);
            deserializedAudioTranscription.task = task;
            deserializedAudioTranscription.language = language;
            deserializedAudioTranscription.duration = duration;
            deserializedAudioTranscription.segments = segments;
            deserializedAudioTranscription.words = words;
            return deserializedAudioTranscription;
        });
    }
}
