/*
 * Decompiled with CFR 0.152.
 */
package com.aventstack.extentreports.model.service;

import com.aventstack.extentreports.gherkin.model.IGherkinFormatterModel;
import com.aventstack.extentreports.model.ExceptionInfo;
import com.aventstack.extentreports.model.Log;
import com.aventstack.extentreports.model.Test;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class TestService {
    public static boolean deleteTest(List<Test> list, Test test) {
        boolean removed = list.removeIf(x -> x.getId() == test.getId());
        if (!removed) {
            list.forEach(x -> {
                boolean bl = TestService.deleteTest(x.getChildren(), test);
            });
        }
        return removed;
    }

    public static Optional<Test> findTest(List<Test> list, String name) {
        Iterator<Test> iterator;
        Optional<Test> test = list.stream().filter(x -> x.getName().equals(name)).findFirst();
        if (!test.isPresent() && (iterator = list.iterator()).hasNext()) {
            Test t = iterator.next();
            return TestService.findTest(t.getChildren(), name);
        }
        return test;
    }

    public static Boolean testHasScreenCapture(Test test, Boolean deep) {
        if (deep.booleanValue()) {
            Boolean hasScreenCapture = !test.getMedia().isEmpty() || test.getLogs().stream().anyMatch(Log::hasMedia);
            if (!hasScreenCapture.booleanValue()) {
                hasScreenCapture = test.getChildren().stream().anyMatch(x -> TestService.testHasScreenCapture(x, deep));
            }
            return hasScreenCapture;
        }
        return test.hasScreenCapture();
    }

    public static List<ExceptionInfo> aggregateExceptions(List<Test> testList) {
        ArrayList<ExceptionInfo> list = new ArrayList<ExceptionInfo>();
        for (Test test : testList) {
            list.addAll(TestService.aggregateExceptions(test));
            if (test.getChildren().isEmpty()) continue;
            TestService.aggregateExceptions(test.getChildren());
        }
        return list;
    }

    public static List<ExceptionInfo> aggregateExceptions(Test test) {
        return test.getLogs().stream().filter(x -> x.getException() != null).map(x -> x.getException()).collect(Collectors.toList());
    }

    public static Test createTest(Class<? extends IGherkinFormatterModel> type, String name, String description) {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("Test name cannot be null or empty");
        }
        return Test.builder().bddType(type).name(name).description(description).endTime(Calendar.getInstance().getTime()).build();
    }

    public static Test createTest(String name, String description) {
        return TestService.createTest(null, name, description);
    }

    public static Test createTest(String name) {
        return TestService.createTest(name, null);
    }
}

