/*
 * Decompiled with CFR 0.152.
 */
package com.aventstack.extentreports.config.external;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;

public class CaseInsensitiveEnumTypeAdapterFactory
implements TypeAdapterFactory {
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        Class rawType = type.getRawType();
        if (!rawType.isEnum()) {
            return null;
        }
        final HashMap lowercaseToConstant = new HashMap();
        T[] TArray = rawType.getEnumConstants();
        int n = TArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object constant = TArray[n2];
            lowercaseToConstant.put(this.toLowercase(constant), constant);
            ++n2;
        }
        return new TypeAdapter<T>(){

            public void write(JsonWriter out, T value) throws IOException {
                if (value == null) {
                    out.nullValue();
                } else {
                    out.value(CaseInsensitiveEnumTypeAdapterFactory.this.toLowercase(value));
                }
            }

            public T read(JsonReader reader) throws IOException {
                if (reader.peek() == JsonToken.NULL) {
                    reader.nextNull();
                    return null;
                }
                return lowercaseToConstant.get(CaseInsensitiveEnumTypeAdapterFactory.this.toLowercase(reader.nextString()));
            }
        };
    }

    private String toLowercase(Object o) {
        return o.toString().toLowerCase(Locale.US);
    }
}

