/*
 * Decompiled with CFR 0.152.
 */
package com.autonomousapps.internal.stringtemplate.v4;

import com.autonomousapps.internal.stringtemplate.v4.STGroup;
import com.autonomousapps.internal.stringtemplate.v4.compiler.CompiledST;
import com.autonomousapps.internal.stringtemplate.v4.compiler.STException;
import com.autonomousapps.internal.stringtemplate.v4.misc.ErrorType;
import com.autonomousapps.internal.stringtemplate.v4.misc.Misc;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;

public class STGroupFile
extends STGroup {
    public String fileName;
    public URL url;
    protected boolean alreadyLoaded = false;

    public STGroupFile(String fileName) {
        this(fileName, '<', '>');
    }

    public STGroupFile(String fileName, char delimiterStartChar, char delimiterStopChar) {
        super(delimiterStartChar, delimiterStopChar);
        if (!fileName.endsWith(GROUP_FILE_EXTENSION)) {
            throw new IllegalArgumentException("Group file names must end in .stg: " + fileName);
        }
        File f = new File(fileName);
        if (f.exists()) {
            try {
                this.url = f.toURI().toURL();
            }
            catch (MalformedURLException e) {
                throw new STException("can't load group file " + fileName, e);
            }
            if (verbose) {
                System.out.println("STGroupFile(" + fileName + ") == file " + f.getAbsolutePath());
            }
        } else {
            this.url = this.getURL(fileName);
            if (this.url == null) {
                throw new IllegalArgumentException("No such group file: " + fileName);
            }
            if (verbose) {
                System.out.println("STGroupFile(" + fileName + ") == url " + this.url);
            }
        }
        this.fileName = fileName;
    }

    public STGroupFile(String fullyQualifiedFileName, String encoding) {
        this(fullyQualifiedFileName, encoding, '<', '>');
    }

    public STGroupFile(String fullyQualifiedFileName, String encoding, char delimiterStartChar, char delimiterStopChar) {
        this(fullyQualifiedFileName, delimiterStartChar, delimiterStopChar);
        this.encoding = encoding;
    }

    public STGroupFile(URL url, String encoding, char delimiterStartChar, char delimiterStopChar) {
        super(delimiterStartChar, delimiterStopChar);
        if (url == null) {
            throw new IllegalArgumentException("URL to group file cannot be null");
        }
        this.url = url;
        this.encoding = encoding;
        this.fileName = null;
    }

    public STGroupFile(URL url) {
        this(url, "UTF-8", '<', '>');
    }

    @Override
    public boolean isDictionary(String name) {
        if (!this.alreadyLoaded) {
            this.load();
        }
        return super.isDictionary(name);
    }

    @Override
    public boolean isDefined(String name) {
        if (!this.alreadyLoaded) {
            this.load();
        }
        return super.isDefined(name);
    }

    @Override
    public synchronized void unload() {
        super.unload();
        this.alreadyLoaded = false;
    }

    @Override
    protected synchronized CompiledST load(String name) {
        if (!this.alreadyLoaded) {
            this.load();
        }
        return this.rawGetTemplate(name);
    }

    @Override
    public synchronized void load() {
        if (this.alreadyLoaded) {
            return;
        }
        this.alreadyLoaded = true;
        if (verbose) {
            System.out.println("loading group file " + this.url.toString());
        }
        this.loadGroupFile("/", this.url.toString());
        if (verbose) {
            System.out.println("found " + this.templates.size() + " templates in " + this.url.toString() + " = " + this.templates.keySet());
        }
    }

    @Override
    public String show() {
        if (!this.alreadyLoaded) {
            this.load();
        }
        return super.show();
    }

    @Override
    public String getName() {
        return Misc.getFileNameNoSuffix(this.getFileName());
    }

    @Override
    public String getFileName() {
        if (this.fileName != null) {
            return this.fileName;
        }
        return this.url.getFile();
    }

    @Override
    public URL getRootDirURL() {
        String parent = Misc.stripLastPathElement(this.url.toString());
        if (parent.endsWith(".jar!")) {
            parent = parent + "/.";
        }
        try {
            URL parentURL = new URL(parent);
            return parentURL;
        }
        catch (MalformedURLException mue) {
            this.errMgr.runTimeError(null, null, ErrorType.INVALID_TEMPLATE_NAME, mue, (Object)parent);
            return null;
        }
    }
}

