/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.jdbc.nonxa;

import com.atomikos.icatch.HeurCommitException;
import com.atomikos.icatch.HeurHazardException;
import com.atomikos.icatch.HeurMixedException;
import com.atomikos.icatch.HeurRollbackException;
import com.atomikos.icatch.Participant;
import com.atomikos.icatch.RollbackException;
import com.atomikos.icatch.SysException;
import com.atomikos.jdbc.nonxa.JtaAwareNonXaConnection;
import com.atomikos.logging.Logger;
import com.atomikos.logging.LoggerFactory;
import java.io.Serializable;
import java.util.Map;

class AtomikosNonXAParticipant
implements Participant,
Serializable {
    private static final Logger LOGGER = LoggerFactory.createLogger(AtomikosNonXAParticipant.class);
    private static final long serialVersionUID = -771461092384746954L;
    private boolean readOnly;
    private String name;
    private transient JtaAwareNonXaConnection connection;

    public AtomikosNonXAParticipant() {
    }

    AtomikosNonXAParticipant(JtaAwareNonXaConnection connection, String name) {
        this.connection = connection;
        this.name = name;
    }

    boolean recover() throws SysException {
        return true;
    }

    public void setCascadeList(Map<String, Integer> allParticipants) throws SysException {
    }

    public void setGlobalSiblingCount(int count) {
    }

    public int prepare() throws RollbackException, HeurHazardException, HeurMixedException, SysException {
        int ret = 1;
        return ret;
    }

    public void commit(boolean onePhase) throws HeurRollbackException, HeurHazardException, HeurMixedException, RollbackException, SysException {
        if (this.isRecovered()) {
            if (!this.readOnly) {
                throw new HeurRollbackException();
            }
        } else {
            try {
                this.connection.transactionTerminated(true);
            }
            catch (Exception e) {
                LOGGER.logError("Error in non-XA commit", (Throwable)e);
                throw new HeurMixedException();
            }
        }
    }

    private boolean isRecovered() {
        return this.connection == null;
    }

    public void rollback() throws HeurCommitException, HeurMixedException, HeurHazardException, SysException {
        if (!this.isRecovered()) {
            try {
                this.connection.transactionTerminated(false);
            }
            catch (Exception e) {
                LOGGER.logError("Error in non-XA rollback", (Throwable)e);
                throw new HeurMixedException();
            }
        }
    }

    public void forget() {
    }

    public String getURI() {
        return null;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public String toString() {
        return "Non-XA resource '" + this.name + "': warning: this resource does not support two-phase commit";
    }

    public boolean isRecoverable() {
        return false;
    }

    public String getResourceName() {
        return this.name;
    }
}

