/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.jdbc;

import com.atomikos.datasource.ResourceTransaction;
import com.atomikos.datasource.TransactionalResource;
import com.atomikos.datasource.xa.XAResourceTransaction;
import com.atomikos.icatch.CompositeTransaction;
import com.atomikos.icatch.CompositeTransactionManager;
import com.atomikos.icatch.system.Configuration;
import com.atomikos.jdbc.AtomikosSQLException;
import com.atomikos.jdbc.DTPPooledConnection;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

class ConnectionProxy
implements InvocationHandler {
    private static final List NON_TRANSACTIONAL_METHOD_NAMES = Arrays.asList("equals", "hashCode", "notify", "notifyAll", "toString", "wait");
    private Connection wrapped_;
    private TransactionalResource resource_;
    private DTPPooledConnection pc_;

    static Set getAllImplementedInterfaces(Class clazz) {
        HashSet ret = null;
        ret = clazz.getSuperclass() != null ? ConnectionProxy.getAllImplementedInterfaces(clazz.getSuperclass()) : new HashSet();
        Class<?>[] interfaces = clazz.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            ret.add(interfaces[i]);
        }
        return ret;
    }

    static Object newInstance(DTPPooledConnection pc, Connection c, TransactionalResource resource) throws SQLException {
        Object ret = null;
        ConnectionProxy proxy = new ConnectionProxy(c, resource, pc);
        Set interfaces = ConnectionProxy.getAllImplementedInterfaces(c.getClass());
        Class[] interfaceClasses = interfaces.toArray(new Class[0]);
        ret = Proxy.newProxyInstance(c.getClass().getClassLoader(), interfaceClasses, (InvocationHandler)proxy);
        return ret;
    }

    private ConnectionProxy(Connection wrapped, TransactionalResource resource, DTPPooledConnection pc) {
        this.wrapped_ = wrapped;
        this.resource_ = resource;
        this.pc_ = pc;
    }

    public Object invoke(Object o, Method m, Object[] args) throws Throwable {
        if (NON_TRANSACTIONAL_METHOD_NAMES.contains(m.getName())) {
            if (Configuration.isDebugLoggingEnabled()) {
                Configuration.logDebug((String)("Calling non-transactional method '" + m.getName() + "' on connection proxy, bypassing enlistment"));
            }
            return m.invoke((Object)this.wrapped_, args);
        }
        Object ret = null;
        XAResourceTransaction restx = null;
        CompositeTransaction ct = null;
        CompositeTransactionManager ctm = null;
        ctm = Configuration.getCompositeTransactionManager();
        boolean inTx = false;
        if (ctm != null) {
            ct = ctm.getCompositeTransaction();
        }
        inTx = this.pc_.isInResourceTransaction();
        if (ct != null && ct.getProperty("com.atomikos.icatch.jta.transaction") != null && !this.pc_.isDiscarded() && !inTx) {
            restx = (XAResourceTransaction)this.resource_.getResourceTransaction(ct);
            this.pc_.setResourceTransaction((ResourceTransaction)restx);
            restx.resume();
            Configuration.logDebug((String)("JDBC ConnectionProxy: using resource transaction: " + restx.getXid()));
        }
        try {
            if (Configuration.isDebugLoggingEnabled()) {
                Configuration.logDebug((String)("JDBC ConnectionProxy: delegating " + m.getName() + " to connection " + this.wrapped_.toString()));
            }
            ret = m.invoke((Object)this.wrapped_, args);
        }
        catch (InvocationTargetException i) {
            this.pc_.setInvalidated();
            this.pc_.close();
            if (Configuration.isDebugLoggingEnabled()) {
                Configuration.logDebug((String)"Exception in pooled connection - closing it", (Throwable)i);
            }
            AtomikosSQLException.throwAtomikosSQLException((String)i.getMessage(), (Throwable)i);
        }
        catch (Exception e) {
            String msg = "Exception in pooled connection: unexpected error - closing it";
            Configuration.logWarning((String)msg, (Throwable)e);
            this.pc_.setInvalidated();
            this.pc_.close();
            AtomikosSQLException.throwAtomikosSQLException((String)e.getMessage(), (Throwable)e);
        }
        return ret;
    }
}

