/*
 * Decompiled with CFR 0.152.
 */
package com.asual.lesscss;

import com.asual.lesscss.LessException;
import com.asual.lesscss.LessOptions;
import com.asual.lesscss.compiler.LessCompiler;
import com.asual.lesscss.compiler.RhinoCompiler;
import com.asual.lesscss.loader.ChainedResourceLoader;
import com.asual.lesscss.loader.ClasspathResourceLoader;
import com.asual.lesscss.loader.CssProcessingResourceLoader;
import com.asual.lesscss.loader.FilesystemResourceLoader;
import com.asual.lesscss.loader.HTTPResourceLoader;
import com.asual.lesscss.loader.JNDIResourceLoader;
import com.asual.lesscss.loader.ResourceLoader;
import com.asual.lesscss.loader.UnixNewlinesResourceLoader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mozilla.javascript.Context;

public class LessEngine {
    private final Log logger = LogFactory.getLog(this.getClass());
    private final LessOptions options;
    private final ResourceLoader loader;
    private LessCompiler compiler;

    public LessEngine() {
        this(new LessOptions());
    }

    public LessEngine(LessOptions options) {
        this(options, LessEngine.defaultResourceLoader(options));
    }

    private static ResourceLoader defaultResourceLoader(LessOptions options) {
        ResourceLoader resourceLoader = new ChainedResourceLoader(new FilesystemResourceLoader(), new ClasspathResourceLoader(LessEngine.class.getClassLoader()), new JNDIResourceLoader(), new HTTPResourceLoader());
        if (options.isCss()) {
            return new CssProcessingResourceLoader(resourceLoader);
        }
        resourceLoader = new UnixNewlinesResourceLoader(resourceLoader);
        return resourceLoader;
    }

    public LessEngine(LessOptions options, ResourceLoader loader) {
        this.options = options;
        this.loader = loader;
        try {
            this.logger.debug((Object)"Initializing LESS Engine.");
            ClassLoader classLoader = this.getClass().getClassLoader();
            URL less = options.getLess();
            URL env = classLoader.getResource("META-INF/env.js");
            URL engine = classLoader.getResource("META-INF/engine.js");
            URL cssmin = classLoader.getResource("META-INF/cssmin.js");
            URL sourceMap = classLoader.getResource("META-INF/source-map.js");
            this.compiler = new RhinoCompiler(options, loader, less, env, engine, cssmin, sourceMap);
            Context.exit();
        }
        catch (Exception e) {
            this.logger.error((Object)"LESS Engine intialization failed.", (Throwable)e);
        }
    }

    public String compile(String input) throws LessException {
        return this.compile(input, null, false);
    }

    public String compile(String input, String location) throws LessException {
        return this.compile(input, location, false);
    }

    public String compile(String input, String location, boolean compress) throws LessException {
        long time = System.currentTimeMillis();
        String result = this.compiler.compile(input, location == null ? "" : location, compress);
        this.logger.debug((Object)("The compilation of '" + input + "' took " + (System.currentTimeMillis() - time) + " ms."));
        return result;
    }

    public String compile(URL input) throws LessException, IOException {
        return this.compile(input, false);
    }

    public String compile(URL input, boolean compress) throws LessException, IOException {
        long time = System.currentTimeMillis();
        String location = input.toString();
        this.logger.debug((Object)("Compiling URL: " + location));
        String source = this.loader.load(this.getFile(location), this.getPaths(location), this.options.getCharset());
        String result = this.compiler.compile(source, location, compress);
        this.logger.debug((Object)("The compilation of '" + input + "' took " + (System.currentTimeMillis() - time) + " ms."));
        return result;
    }

    public String compile(File input) throws LessException, IOException {
        return this.compile(input, false);
    }

    public String compile(File input, boolean compress) throws LessException, IOException {
        long time = System.currentTimeMillis();
        String location = input.getAbsolutePath();
        this.logger.debug((Object)("Compiling File: file:" + location));
        String source = null;
        source = this.loader.load(this.getFile(location), this.getPaths(location), this.options.getCharset());
        String result = this.compiler.compile(source, location, compress);
        this.logger.debug((Object)("The compilation of '" + input + "' took " + (System.currentTimeMillis() - time) + " ms."));
        return result;
    }

    public void compile(File input, File output) throws LessException, IOException {
        this.compile(input, output, false);
    }

    public void compile(File input, File output, boolean compress) throws LessException, IOException {
        String content = this.compile(input, compress);
        if (!output.exists()) {
            output.createNewFile();
        }
        BufferedWriter bw = new BufferedWriter(new FileWriter(output));
        bw.write(content);
        bw.close();
    }

    private String[] getPaths(String currentFile) {
        String currentPath;
        String[] paths = this.options.getPaths() != null ? Arrays.copyOf(this.options.getPaths(), this.options.getPaths().length + 1) : new String[1];
        paths[paths.length - 1] = currentPath = currentFile.replaceAll("^(.*[\\/\\\\])[^\\/\\\\]*$", "$1");
        for (int i = 0; i < paths.length; ++i) {
            paths[i] = paths[i].replace('\\', '/');
        }
        return paths;
    }

    private String getFile(String currentFile) {
        String file = currentFile.replaceAll("^(.*[\\/\\\\])([^\\/\\\\]*)$", "$2");
        return file;
    }
}

