/*
 * Decompiled with CFR 0.152.
 */
package com.groupcdg.arcmutate.spring.testtargetting;

import com.groupcdg.arcmutate.spring.MutableAnnotation;
import com.groupcdg.arcmutate.spring.mutators.IdEncoder;
import com.groupcdg.arcmutate.spring.mutators.Position;
import com.groupcdg.arcmutate.spring.testtargetting.ClassHierarchies;
import com.groupcdg.arcmutate.spring.testtargetting.Inherit;
import com.groupcdg.arcmutate.spring.testtargetting.TimingOnlyComparator;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.pitest.bytecode.analysis.ClassTree;
import org.pitest.bytecode.analysis.MethodTree;
import org.pitest.classinfo.ClassName;
import org.pitest.classpath.CodeSource;
import org.pitest.coverage.BlockLocation;
import org.pitest.coverage.CoverageDatabase;
import org.pitest.coverage.TestInfo;
import org.pitest.mutationtest.build.DefaultTestPrioritiser;
import org.pitest.mutationtest.build.TestPrioritiser;
import org.pitest.mutationtest.engine.MutationDetails;
import org.pitest.mutationtest.engine.MutationIdentifier;

public class AnnotationAwarePrioritiser
implements TestPrioritiser {
    private final CodeSource code;
    private final CoverageDatabase coverage;
    private final DefaultTestPrioritiser defaultRoute;
    private final ClassHierarchies hierarchy;

    public AnnotationAwarePrioritiser(CodeSource code, CoverageDatabase coverage, ClassHierarchies hierarchy) {
        this.code = code;
        this.coverage = coverage;
        this.defaultRoute = new DefaultTestPrioritiser(coverage);
        this.hierarchy = hierarchy;
    }

    public List<TestInfo> assignTests(MutationDetails mutation) {
        Position position = IdEncoder.parsePosition(mutation.getId());
        boolean requiresCoverageRewrite = MutableAnnotation.fromMutator(mutation.getId().getMutator()).map(an -> an.rewriteCoverage() || position.isForceCoverageRewrite()).orElse(false);
        if (requiresCoverageRewrite) {
            List<ClassName> classes = this.findAffectedClasses(mutation.getId());
            return classes.stream().flatMap(c -> this.findConstructorTests((ClassName)c)).distinct().sorted(new TimingOnlyComparator()).collect(Collectors.toList());
        }
        return this.defaultRoute.assignTests(mutation);
    }

    private List<ClassName> findAffectedClasses(MutationIdentifier id) {
        Position position = IdEncoder.parsePosition(id);
        Inherit inherit = MutableAnnotation.fromMutator(id.getMutator()).map(MutableAnnotation::inherit).orElse(Inherit.NO_INHERIT);
        if (position == Position.CLASS && inherit == Inherit.INHERIT) {
            return this.hierarchy.children(id.getClassName());
        }
        return Collections.singletonList(id.getClassName());
    }

    private Stream<TestInfo> findConstructorTests(ClassName clazz) {
        Optional bytes = this.code.fetchClassBytes(clazz);
        Optional<ClassTree> maybeTree = bytes.map(b -> ClassTree.fromBytes((byte[])b));
        if (maybeTree.isEmpty()) {
            return Stream.empty();
        }
        ClassTree tree = maybeTree.get();
        return tree.methods().stream().filter(m -> m.rawNode().name.equals("<init>")).map(MethodTree::asLocation).flatMap(l -> this.coverage.getTestsForBlockLocation(new BlockLocation(l, 0)).stream());
    }
}

